/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.czechaddress.addressdatabase;

import java.util.List;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.plugins.czechaddress.NotNullList;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.AddressElement;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.ElementWithHouses;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.ParentResolver;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.Street;
import org.openstreetmap.josm.plugins.czechaddress.proposal.Proposal;
import org.openstreetmap.josm.plugins.czechaddress.proposal.ProposalFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class House
extends AddressElement {
    protected String cp = null;
    protected String co = null;

    public House(String cp, String co) {
        super("");
        if (cp != null) {
            this.cp = cp.toLowerCase();
        }
        if (co != null) {
            this.co = co.toLowerCase();
        }
        assert (co != null || cp != null);
        this.name = House.generateName(this.cp, this.co);
    }

    public String getCP() {
        return this.cp;
    }

    public String getCO() {
        return this.co;
    }

    public static String generateName(String cp, String co) {
        if (cp != null && co != null) {
            return cp + "/" + co;
        }
        if (co != null) {
            return co;
        }
        if (cp != null) {
            return cp;
        }
        assert (false);
        return "";
    }

    @Override
    public String getName() {
        assert (this.parent != null) : "A house must always have a parent.";
        return this.parent.getName() + " " + this.name;
    }

    @Override
    public void setParent(AddressElement parent) {
        assert (parent instanceof ElementWithHouses);
        super.setParent(parent);
    }

    @Override
    public ElementWithHouses getParent() {
        assert (this.parent instanceof ElementWithHouses);
        return (ElementWithHouses)this.parent;
    }

    @Override
    protected int[] getFieldMatchList(OsmPrimitive prim) {
        int[] result = new int[]{0, 0};
        result[0] = House.matchField(this.cp, prim.get("addr:alternatenumber"));
        if (this.parent instanceof Street) {
            result[1] = Math.min(House.matchField(this.parent.getName(), prim.get("addr:street")), House.matchField(this.co, prim.get("addr:housenumber")));
        }
        return result;
    }

    @Override
    public List<Proposal> getDiff(OsmPrimitive prim) {
        NotNullList<Proposal> props = new NotNullList<Proposal>();
        ParentResolver pr = new ParentResolver(this);
        props.add(ProposalFactory.getStringFieldDiff("addr:alternatenumber", prim.get("addr:alternatenumber"), this.getCP()));
        props.add(ProposalFactory.getStringFieldDiff("addr:housenumber", prim.get("addr:housenumber"), this.getCO()));
        props.add(ProposalFactory.getStringFieldDiff("addr:country", prim.get("addr:country"), "CZ"));
        if (pr.parentStreet != null) {
            props.add(ProposalFactory.getStringFieldDiff("addr:street", prim.get("addr:street"), pr.parentStreet.getName()));
        }
        if (this.parent.parent != null) {
            props.add(ProposalFactory.getStringFieldDiff("is_in", prim.get("is_in"), this.parent.parent.getIsIn()));
        }
        if (props.size() > 0) {
            props.add(ProposalFactory.getListFieldDiff("source:addr", prim.get("source:addr"), "mvcr:adresa"));
        }
        return props;
    }
}

