/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.czechaddress.addressdatabase;

import java.util.List;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.czechaddress.StringUtils;
import org.openstreetmap.josm.plugins.czechaddress.proposal.Proposal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AddressElement {
    protected String name;
    protected AddressElement parent = null;
    protected static final String KEY_ADDR_CP = "addr:alternatenumber";
    protected static final String KEY_ADDR_CO = "addr:housenumber";
    protected static final String KEY_ADDR_STREET = "addr:street";
    protected static final String KEY_ADDR_CITY = "addr:city";
    protected static final String KEY_ADDR_COUNTRY = "addr:country";
    protected static final String KEY_IS_IN = "is_in";
    protected static final String KEY_NAME = "name";

    public AddressElement(String name) {
        if (name == null) {
            throw new NullPointerException("You must specify the name of this AddressElement");
        }
        this.name = AddressElement.capitalize(name);
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public String getName() {
        return this.name;
    }

    public static String getName(Object o) {
        if (o instanceof OsmPrimitive) {
            return AddressElement.getName((OsmPrimitive)o);
        }
        if (o instanceof AddressElement) {
            return ((AddressElement)o).getName();
        }
        return null;
    }

    public static String getName(OsmPrimitive prim) {
        String cp = prim.get(KEY_ADDR_CP);
        String co = prim.get(KEY_ADDR_CO);
        String street = prim.get(KEY_ADDR_STREET);
        String city = prim.get(KEY_ADDR_CITY);
        String name = prim.get(KEY_NAME);
        String result = "";
        if (name != null) {
            result = result + name;
        }
        if (street != null) {
            if (result.length() > 0) {
                result = result + ", ";
            }
            result = result + street;
        } else if (city != null) {
            if (result.length() > 0) {
                result = result + ", ";
            }
            result = result + city;
        }
        if (cp != null) {
            if (result.length() > 0) {
                result = result + " ";
            }
            result = result + cp;
        }
        if (co != null) {
            if (co != null) {
                result = result + "/";
            }
            result = result + co;
        }
        if (prim instanceof Node) {
            result = result + " " + StringUtils.latLonToString(((Node)prim).coor);
        } else if (prim instanceof Way) {
            result = result + " " + StringUtils.latLonToString(((Way)prim).firstNode().coor);
        }
        return result;
    }

    public void setParent(AddressElement parent) {
        this.parent = parent;
    }

    public AddressElement getParent() {
        return this.parent;
    }

    public boolean equals(AddressElement elem) {
        if (elem == null) {
            return false;
        }
        return this.name.equals(elem.name) && this.parent == elem.parent;
    }

    public String toString() {
        return this.parent == null ? this.getName() : this.getName() + ", " + this.parent.toString();
    }

    protected static String capitalize(String s) {
        String[] noCapitalize;
        if (s == null) {
            return s;
        }
        String result = "";
        char last = ' ';
        for (char ch : s.toCharArray()) {
            ch = last >= 'a' && last <= '\u017e' || last >= 'A' && last <= '\u017d' ? Character.toLowerCase(ch) : Character.toTitleCase(ch);
            last = ch;
            result = result + ch;
        }
        for (String noc : noCapitalize = new String[]{"Nad", "Pod", "U", "Na"}) {
            result = result.replaceAll(" " + noc + " ", " " + noc.toLowerCase() + " ");
        }
        return result;
    }

    public static int matchField(String elemValue, String primValue) {
        if (elemValue == null) {
            return 0;
        }
        if (primValue == null) {
            return -1;
        }
        return primValue.trim().toUpperCase().equals(elemValue.trim().toUpperCase()) ? 1 : -1;
    }

    protected int[] getFieldMatchList(OsmPrimitive primitive) {
        int[] result = new int[]{0};
        return result;
    }

    public List<Proposal> getDiff(OsmPrimitive prim) {
        return null;
    }

    public int getMatchQuality(OsmPrimitive primitive) {
        int[] fieldMatches = this.getFieldMatchList(primitive);
        assert (fieldMatches.length > 0);
        int minVal = fieldMatches[0];
        int maxVal = fieldMatches[0];
        for (int i = 1; i < fieldMatches.length; ++i) {
            if (minVal > fieldMatches[i]) {
                minVal = fieldMatches[i];
            }
            if (maxVal >= fieldMatches[i]) continue;
            maxVal = fieldMatches[i];
        }
        assert (Math.abs(minVal) <= 1);
        assert (Math.abs(maxVal) <= 1);
        if (maxVal <= 0) {
            return 0;
        }
        switch (minVal * maxVal) {
            case -1: {
                return 1;
            }
            case 0: {
                return 2;
            }
            case 1: {
                return 3;
            }
        }
        return 0;
    }

    public String getIsIn() {
        return this.getIsIn(null);
    }

    protected String getIsInName() {
        return this.getName();
    }

    private String getIsIn(String childString) {
        String result = "";
        if (this.getIsInName() != null && !this.getIsInName().equals(childString)) {
            result = result + this.getIsInName() + ", ";
        }
        result = this.parent != null ? result + this.parent.getIsIn(this.getIsInName()) : result + "CZ";
        return result;
    }
}

