/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.czechaddress;

import org.openstreetmap.josm.data.coor.LatLon;

public class StringUtils {
    public static String extractNumber(String s) {
        char ch;
        String result = "";
        for (int i = 0; i < s.length() && (ch = s.charAt(i)) >= '0' && ch <= '9'; ++i) {
            result = result + ch;
        }
        return result;
    }

    public static String coordinateToString(double coor) {
        double degrees = Math.floor(coor);
        double minutes = Math.floor(60.0 * (coor - degrees));
        double seconds = 3600.0 * (coor - degrees - minutes / 60.0);
        return String.valueOf(Math.round(degrees)) + "\u00b0" + String.valueOf(Math.round(minutes)) + "'" + String.valueOf((double)Math.round(100.0 * seconds) / 100.0) + "\"";
    }

    public static String latLonToString(LatLon position) {
        assert (position != null);
        return "(lat: " + StringUtils.coordinateToString(position.lat()) + " lon: " + StringUtils.coordinateToString(position.lon()) + ")";
    }

    public boolean matchAbbrev(String s1, String s2) {
        String[] parts2;
        String[] parts1 = s1.split(" +");
        if (parts1.length != (parts2 = s2.split(" +")).length) {
            return false;
        }
        for (int i = 0; i < parts1.length; ++i) {
            int minLen;
            String part1 = parts1[i];
            String part2 = parts2[i];
            if (part1.charAt(part1.length() - 1) == '.') {
                part1 = part1.substring(0, part1.length() - 1);
            }
            if (part2.charAt(part2.length() - 1) == '.') {
                part2 = part2.substring(0, part2.length() - 1);
            }
            if ((part1 = part1.substring(0, minLen = Math.min(part1.length(), part2.length())).toUpperCase()).equals(part2 = part2.substring(0, minLen).toUpperCase())) continue;
            return false;
        }
        return true;
    }
}

