/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.czechaddress.parser;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.czechaddress.DatabaseLoadException;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.ElementWithHouses;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.House;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.Region;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.Street;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.Suburb;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.ViToCi;
import org.openstreetmap.josm.plugins.czechaddress.parser.XMLParser;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class MvcrParser
extends XMLParser {
    Region curRegion = null;
    ViToCi curViToCi = null;
    Suburb curSuburb = null;
    Street curStreet = null;
    String filRegion = null;
    String filViToCi = null;
    String filSuburb = null;
    String filStreet = null;
    static final String URL_DEFAULT = "http://web.mvcr.cz/adresa/adresy.zip";
    static final String URL_PREFERENCES_KEY = "czechaddress.databaseurl";

    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        ElementWithHouses topElem;
        if (name.equals("oblast")) {
            if (this.filRegion != null && !attributes.getValue("nazev").equals(this.filRegion)) {
                return;
            }
            this.curRegion = new Region(attributes.getValue("nazev"), attributes.getValue("kraj"), attributes.getValue("okres"));
            this.target.regions.add(this.curRegion);
        }
        if (this.curRegion == null) {
            return;
        }
        if (name.equals("obec")) {
            if (this.filViToCi != null && !attributes.getValue("nazev").equals(this.filViToCi)) {
                return;
            }
            this.curViToCi = new ViToCi(attributes.getValue("nazev"));
            this.curRegion.addViToCi(this.curViToCi);
        }
        if (name.equals("cast")) {
            if (this.curViToCi == null) {
                return;
            }
            if (this.filSuburb != null && !attributes.getValue("nazev").equals(this.filSuburb)) {
                return;
            }
            this.curSuburb = new Suburb(attributes.getValue("nazev"));
            this.curViToCi.addSuburb(this.curSuburb);
        }
        if (name.equals("ulice")) {
            if (this.filStreet != null && !attributes.getValue("nazev").equals(this.filStreet)) {
                return;
            }
            topElem = this.curSuburb;
            if (topElem == null) {
                topElem = this.curViToCi;
            }
            if (topElem == null) {
                topElem = this.curRegion;
            }
            this.curStreet = new Street(attributes.getValue("nazev"));
            topElem.addStreet(this.curStreet);
        }
        if (name.equals("a")) {
            if (attributes.getValue("p") == null && attributes.getValue("o") == null) {
                return;
            }
            topElem = this.curStreet;
            if (topElem == null) {
                topElem = this.curSuburb;
            }
            if (topElem == null) {
                topElem = this.curViToCi;
            }
            if (topElem == null) {
                topElem = this.curRegion;
            }
            topElem.addHouse(new House(attributes.getValue("p"), attributes.getValue("o")));
        }
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        if (name.equals("cast")) {
            this.curSuburb = null;
        } else if (name.equals("obec")) {
            this.curSuburb = null;
            this.curViToCi = null;
        } else if (name.equals("oblast")) {
            this.curSuburb = null;
            this.curViToCi = null;
            this.curRegion = null;
        } else if (name.equals("ulice")) {
            this.curStreet = null;
        }
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void setFilter(String filterRegion, String filterViToCi, String filterSuburb, String filterStreet) {
        if (filterRegion != null) {
            this.filRegion = filterRegion.toUpperCase();
        }
        if (filterViToCi != null) {
            this.filViToCi = filterViToCi.toUpperCase();
        }
        if (filterSuburb != null) {
            this.filSuburb = filterSuburb.toUpperCase();
        }
        if (filterStreet != null) {
            this.filStreet = filterStreet.toUpperCase();
        }
    }

    protected String getDatabaseUrl() {
        if (!Main.pref.hasKey(URL_PREFERENCES_KEY)) {
            Main.pref.put(URL_PREFERENCES_KEY, URL_DEFAULT);
        }
        return Main.pref.get(URL_PREFERENCES_KEY);
    }

    protected String getDatabasePath() {
        return this.storageDir + "-adresy.zip";
    }

    protected InputStream getDatabaseStream() throws DatabaseLoadException {
        ZipInputStream zis;
        ZipEntry zipEntry = null;
        try {
            zis = new ZipInputStream(new FileInputStream(this.getDatabasePath()));
            while ((zipEntry = zis.getNextEntry()) != null && !zipEntry.getName().equals("adresy.xml")) {
            }
        }
        catch (IOException ioexp) {
            throw new DatabaseLoadException("Chyba p\u0159i \u010dten\u00ed archivu s datab\u00e1z\u00ed.");
        }
        if (zipEntry == null) {
            throw new DatabaseLoadException("ZIP archiv s datab\u00e1z\u00ed neobsahuje soubor 'adresy.xml'.");
        }
        return zis;
    }
}

