/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.czechaddress.parser;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.czechaddress.DatabaseLoadException;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.Database;

public abstract class DatabaseParser {
    protected String storageDir = Main.pref.getPreferencesDir();
    protected Database target = null;

    public void setStorageDir(String storageDir) {
        this.storageDir = storageDir;
    }

    public void setTargetDatabase(Database targetDatabase) {
        this.target = targetDatabase;
    }

    public void fillDatabase() throws DatabaseLoadException {
        assert (this.target != null);
        if (!new File(this.getDatabasePath()).exists()) {
            System.err.println("CzechAddress: Soubor s datab\u00e1z\u00ed \u010desk\u00fdch adres na disku nenalazen. Pokus\u00edm se jej st\u00e1hnout.");
            this.downloadDatabase();
        }
        this.parseDatabase();
    }

    protected abstract void parseDatabase() throws DatabaseLoadException;

    protected abstract String getDatabaseUrl();

    protected abstract String getDatabasePath();

    protected abstract InputStream getDatabaseStream() throws DatabaseLoadException;

    protected void downloadDatabase() throws DatabaseLoadException {
        try {
            int count;
            URL url = new URL(this.getDatabaseUrl());
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.connect();
            System.err.println("CzechAddress: Server vr\u00e1til: " + con.getResponseMessage());
            if (con.getResponseCode() != 200) {
                throw new DatabaseLoadException("Po\u017eadavek na server MV\u010cR selhal, \u010d\u00edslo chyby: " + String.valueOf(con.getResponseCode()));
            }
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(this.getDatabasePath()));
            int total = 0;
            byte[] buffer = new byte[131072];
            while ((count = con.getInputStream().read(buffer)) >= 0) {
                bos.write(buffer, 0, count);
                System.err.println("CzechAddress: MV\u010cR database: " + String.valueOf((total += count) / 1024) + " kb downloaded.");
            }
            bos.close();
            if (con.getHeaderField("Error") != null) {
                String er = con.getHeaderField("Error");
                throw new DatabaseLoadException("Server vr\u00e1til chybu: " + er);
            }
            con.disconnect();
        }
        catch (IOException ioexp) {
            ioexp.printStackTrace();
            throw new DatabaseLoadException("Chyba p\u0159i na\u010d\u00edt\u00e1n\u00ed datab\u00e1ze");
        }
    }
}

