/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.czechaddress.gui;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.plugins.czechaddress.CzechAddressPlugin;
import org.openstreetmap.josm.plugins.czechaddress.NotNullList;
import org.openstreetmap.josm.plugins.czechaddress.StatusListener;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.AddressElement;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.House;
import org.openstreetmap.josm.plugins.czechaddress.gui.HalfCookedComboBoxModel;
import org.openstreetmap.josm.plugins.czechaddress.intelligence.Match;
import org.openstreetmap.josm.plugins.czechaddress.intelligence.Reasoner;
import org.openstreetmap.josm.plugins.czechaddress.proposal.Proposal;
import org.openstreetmap.josm.plugins.czechaddress.proposal.ProposalContainer;
import org.openstreetmap.josm.plugins.czechaddress.proposal.ProposalListPainter;
import org.openstreetmap.josm.tools.ImageProvider;

public class PointManipulatorDialog
extends ExtendedDialog
implements StatusListener {
    private Timer updateMatchesTimes = null;
    private Action updateMatchesAction;
    private ProposalContainer proposalContainer;
    private JTextField alternateNumberEdit;
    private JButton changeLocationButton;
    private JButton ensureConsistencyButton;
    private JLabel jLabel1;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JScrollPane jScrollPane1;
    private JTextField locationEdit;
    private JPanel mainPanel;
    private JComboBox matchesComboBox;
    private JList proposalList;

    public PointManipulatorDialog(OsmPrimitive primitive) {
        super(Main.parent, "Adresn\u00ed bod", new String[]{"OK", "Zru\u0161it"}, true);
        this.initComponents();
        this.updateMatchesAction = new AbstractAction(){
            boolean shouldDraw = false;

            public void actionPerformed(ActionEvent e) {
                PointManipulatorDialog.this.updateMatches();
            }
        };
        CzechAddressPlugin.addStatusListener(this);
        this.updateLocation();
        this.proposalContainer = new ProposalContainer(primitive);
        this.proposalList.setModel(this.proposalContainer);
        this.proposalList.setCellRenderer(new ProposalListPainter());
        this.matchesComboBox.setModel(new MatchesComboBoxModel());
        this.matchesComboBox.setRenderer(new MatchesComboBoxPainter());
        if (primitive.get("addr:alternatenumber") != null) {
            this.alternateNumberEdit.setText(primitive.get("addr:alternatenumber"));
            this.updateMatches();
        }
        this.setupDialog(this.mainPanel, new String[]{"ok.png", "cancel.png"});
        this.setDefaultCloseOperation(2);
        this.setAlwaysOnTop(false);
        this.setModal(false);
    }

    protected void buttonAction(ActionEvent evt) {
        super.buttonAction(evt);
        if (this.getValue() == 1) {
            this.proposalContainer.applyAll();
            Main.ds.setSelected(new OsmPrimitive[]{null});
            Main.ds.setSelected(new OsmPrimitive[]{this.proposalContainer.getTarget()});
            Reasoner r = CzechAddressPlugin.getReasoner();
            Match m = (Match)this.matchesComboBox.getSelectedItem();
            if (m != null) {
                r.overwriteMatch(m.elem, m.prim);
            }
        }
        CzechAddressPlugin.removeStatusListener(this);
    }

    public void updateLocation() {
        this.locationEdit.setText(CzechAddressPlugin.getLocation().toString());
    }

    public void updateMatches() {
        if (this.proposalContainer.getTarget().deleted) {
            this.setVisible(false);
        }
        OsmPrimitive prim = this.proposalContainer.getTarget();
        Map backup = prim.keys;
        prim.keys = null;
        prim.put("addr:alternatenumber", this.alternateNumberEdit.getText());
        Reasoner r = CzechAddressPlugin.getReasoner();
        NotNullList<Match> matches = r.getMatchesForPrimitive(prim);
        prim.keys = backup;
        MatchesComboBoxModel matchesModel = (MatchesComboBoxModel)this.matchesComboBox.getModel();
        matchesModel.setMatches(matches);
        if (matchesModel.getSize() > 0) {
            this.matchesComboBox.setSelectedIndex(0);
            return;
        }
        House fakeHouse = new House(this.alternateNumberEdit.getText(), null);
        fakeHouse.setParent(CzechAddressPlugin.getLocation());
        this.proposalContainer.setProposals(fakeHouse.getDiff(this.proposalContainer.getTarget()));
    }

    public void pluginStatusChanged(int message) {
        if (message == 1) {
            this.updateLocation();
            this.mainPanel.setEnabled(false);
        } else if (message == 2) {
            this.updateMatches();
            this.mainPanel.setEnabled(true);
        }
    }

    private void initComponents() {
        this.jLabel4 = new JLabel();
        this.mainPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.alternateNumberEdit = new JTextField();
        this.jLabel5 = new JLabel();
        this.locationEdit = new JTextField();
        this.changeLocationButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.proposalList = new JList();
        this.matchesComboBox = new JComboBox();
        this.jLabel6 = new JLabel();
        this.ensureConsistencyButton = new JButton();
        this.jLabel4.setText("jLabel4");
        this.getContentPane().setLayout(new GridLayout(1, 0));
        this.jLabel1.setText("\u010c\u00edslo popisn\u00e9:");
        this.alternateNumberEdit.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                PointManipulatorDialog.this.keyReleased(evt);
            }
        });
        this.jLabel5.setText("M\u00edsto:");
        this.locationEdit.setEditable(false);
        this.locationEdit.setFocusable(false);
        this.changeLocationButton.setText("Zm\u011bnit");
        this.changeLocationButton.setFocusable(false);
        this.changeLocationButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PointManipulatorDialog.this.changeLocationButtonActionPerformed(evt);
            }
        });
        this.proposalList.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                PointManipulatorDialog.this.proposalListKeyReleased(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.proposalList);
        this.matchesComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{""}));
        this.matchesComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                PointManipulatorDialog.this.matchChanged(evt);
            }
        });
        this.jLabel6.setText("Zaznam v databazi:");
        this.ensureConsistencyButton.setIcon(ImageProvider.get((String)"actions", (String)"refresh-small.png"));
        this.ensureConsistencyButton.setText("");
        this.ensureConsistencyButton.setToolTipText("Provede nov\u00e9 p\u0159i\u0159azen\u00ed prvk\u016f mapy na elementy datab\u00e1ze.\nTouto volbou se zru\u0161\u00ed v\u0161echny manu\u00e1ln\u011b vy\u0159e\u0161en\u00e9 konflikty.");
        this.ensureConsistencyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PointManipulatorDialog.this.ensureConsistencyButtonActionPerformed(evt);
            }
        });
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel6).addComponent(this.jLabel1).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, mainPanelLayout.createSequentialGroup().addComponent(this.locationEdit, -1, 249, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.changeLocationButton)).addComponent(this.alternateNumberEdit, -1, 306, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, mainPanelLayout.createSequentialGroup().addComponent(this.matchesComboBox, 0, 208, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ensureConsistencyButton)))).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 433, Short.MAX_VALUE)));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.locationEdit, -2, -1, -2).addComponent(this.jLabel5).addComponent(this.changeLocationButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.alternateNumberEdit, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.matchesComboBox, -2, -1, -2).addComponent(this.ensureConsistencyButton)).addContainerGap(179, Short.MAX_VALUE)).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addGap(92, 92, 92).addComponent(this.jScrollPane1, -1, 175, Short.MAX_VALUE))));
        this.getContentPane().add(this.mainPanel);
    }

    private void changeLocationButtonActionPerformed(ActionEvent evt) {
        CzechAddressPlugin.changeLocation();
    }

    private void keyReleased(KeyEvent evt) {
        if (this.updateMatchesTimes != null) {
            this.updateMatchesTimes.stop();
        }
        this.updateMatchesTimes = new Timer(300, this.updateMatchesAction);
        this.updateMatchesTimes.setRepeats(false);
        this.updateMatchesTimes.start();
    }

    private void proposalListKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 127) {
            for (Object o : this.proposalList.getSelectedValues()) {
                this.proposalContainer.removeProposal((Proposal)o);
            }
        }
    }

    private void matchChanged(ItemEvent evt) {
        if (this.matchesComboBox.getSelectedItem() == null) {
            return;
        }
        Match match = (Match)this.matchesComboBox.getSelectedItem();
        this.proposalContainer.setProposals(match.elem.getDiff(this.proposalContainer.getTarget()));
    }

    private void ensureConsistencyButtonActionPerformed(ActionEvent evt) {
        CzechAddressPlugin.getReasoner().ensureConsistency();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MatchesComboBoxModel
    extends HalfCookedComboBoxModel {
        private List<Match> matches = null;
        int selectedIndex = -1;

        private MatchesComboBoxModel() {
        }

        public void setMatches(List<Match> matches) {
            this.matches = matches;
            this.selectedIndex = -1;
            this.notifyAllListeners();
        }

        @Override
        public void setSelectedItem(Object anItem) {
            if (this.matches == null) {
                return;
            }
            this.selectedIndex = this.matches.indexOf(anItem);
        }

        @Override
        public Object getSelectedItem() {
            return this.getElementAt(this.selectedIndex);
        }

        @Override
        public int getSize() {
            if (this.matches == null) {
                return 0;
            }
            return this.matches.size();
        }

        @Override
        public Object getElementAt(int index) {
            if (this.matches == null) {
                return null;
            }
            if (index < 0 || index >= this.matches.size()) {
                return null;
            }
            return this.matches.get(index);
        }
    }

    private class MatchesComboBoxPainter
    extends DefaultListCellRenderer {
        ImageIcon envelopeNormIcon = ImageProvider.get((String)"envelope-closed-small.png");
        ImageIcon envelopeStarIcon = ImageProvider.get((String)"envelope-closed-star-small.png");
        ImageIcon envelopeExclIcon = ImageProvider.get((String)"envelope-closed-exclamation-small.png");

        private MatchesComboBoxPainter() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            Reasoner r = CzechAddressPlugin.getReasoner();
            this.setIcon(null);
            if (value instanceof Match) {
                Match match = (Match)value;
                this.setText(AddressElement.getName(match.elem));
                if (match.elem instanceof House) {
                    this.setIcon(this.envelopeStarIcon);
                    if (r.getConflicts(match.elem) != null) {
                        this.setIcon(this.envelopeExclIcon);
                    } else if (r.translate(match.elem) != null) {
                        this.setIcon(this.envelopeNormIcon);
                    }
                }
            }
            return c;
        }
    }
}

