/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.czechaddress.gui;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.tree.TreePath;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.plugins.czechaddress.CzechAddressPlugin;
import org.openstreetmap.josm.plugins.czechaddress.StatusListener;
import org.openstreetmap.josm.plugins.czechaddress.gui.UniversalTreeRenderer;
import org.openstreetmap.josm.plugins.czechaddress.intelligence.Reasoner;
import org.openstreetmap.josm.plugins.czechaddress.proposal.Proposal;
import org.openstreetmap.josm.plugins.czechaddress.proposal.ProposalContainer;
import org.openstreetmap.josm.plugins.czechaddress.proposal.ProposalDatabase;

public class GroupManipulatorDialog
extends ExtendedDialog
implements StatusListener {
    private static GroupManipulatorDialog singleton = null;
    private JLabel jLabel3;
    private JScrollPane jScrollPane1;
    private JButton locationChangeButton;
    private JLabel locationLabel;
    private JTextField locationTextField;
    private JPanel mainPanel;
    private JTree proposalTree;

    public static GroupManipulatorDialog getInstence() {
        if (singleton == null) {
            singleton = new GroupManipulatorDialog();
        }
        return singleton;
    }

    public GroupManipulatorDialog() {
        super(Main.parent, "P\u0159i\u0159adit adresy", new String[]{"OK", "Zru\u0161it"}, true);
        this.initComponents();
        this.proposalTree.setCellRenderer(new UniversalTreeRenderer());
        this.setupDialog(this.mainPanel, new String[]{"ok.png", "cancel.png"});
        this.setDefaultCloseOperation(2);
        this.setAlwaysOnTop(false);
        CzechAddressPlugin.addStatusListener(this);
        this.setModal(false);
    }

    protected void buttonAction(ActionEvent evt) {
        super.buttonAction(evt);
        if (this.getValue() == 1) {
            ((ProposalDatabase)this.proposalTree.getModel()).applyAll();
        }
    }

    public void pluginStatusChanged(int message) {
        int retval;
        if (message == 2 && (retval = new ExtendedDialog(Main.parent, "Zm\u011bna um\u00edst\u011bn\u00ed", "Do\u0161lo ke zm\u011bn\u011b v p\u0159i\u0159azen\u00ed datab\u00e1ze.\nP\u0159ejete si znovu na\u010d\u00edst seznam navrhovan\u00fdch zm\u011bn?", new String[]{"Ano", "Ne"}, new String[]{"ok.png", "cancel.png"}).getValue()) == 1) {
            this.recreateProposals();
        }
    }

    public void setVisible(boolean b) {
        if (!this.isVisible() && b) {
            this.recreateProposals();
        }
        if (b) {
            CzechAddressPlugin.addStatusListener(this);
        } else {
            CzechAddressPlugin.removeStatusListener(this);
        }
        super.setVisible(b);
    }

    public void recreateProposals() {
        this.locationTextField.setText(CzechAddressPlugin.getLocation().toString());
        Reasoner r = CzechAddressPlugin.getReasoner();
        this.proposalTree.setModel(r.getProposals());
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.locationLabel = new JLabel();
        this.locationChangeButton = new JButton();
        this.locationTextField = new JTextField();
        this.jLabel3 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.proposalTree = new JTree();
        this.setLayout(new GridLayout());
        this.locationLabel.setText("M\u00edsto:");
        this.locationChangeButton.setText("Zm\u011bnit");
        this.locationChangeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GroupManipulatorDialog.this.locationChangeButtonActionPerformed(evt);
            }
        });
        this.locationTextField.setEditable(false);
        this.jLabel3.setText("\u2022 Pro smaz\u00e1n\u00ed n\u00e1vrhu pou\u017eijte kl\u00e1vesu Del.");
        this.jLabel3.setVerticalAlignment(1);
        this.proposalTree.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                GroupManipulatorDialog.this.proposalTreeKeyReleased(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.proposalTree);
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addComponent(this.locationLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.locationTextField, -1, 379, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.locationChangeButton)).addComponent(this.jScrollPane1, -1, 482, Short.MAX_VALUE).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel3, -1, 458, Short.MAX_VALUE).addContainerGap()));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.locationTextField, -2, -1, -2).addComponent(this.locationChangeButton).addComponent(this.locationLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 223, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3)));
        this.add(this.mainPanel);
    }

    private void locationChangeButtonActionPerformed(ActionEvent evt) {
        CzechAddressPlugin.changeLocation();
    }

    private void proposalTreeKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 127) {
            for (TreePath path : this.proposalTree.getSelectionPaths()) {
                if (path.getLastPathComponent() instanceof Proposal) {
                    ProposalContainer pc = (ProposalContainer)path.getParentPath().getLastPathComponent();
                    pc.removeProposal((Proposal)path.getLastPathComponent());
                    continue;
                }
                if (!(path.getLastPathComponent() instanceof ProposalContainer)) continue;
                ((ProposalDatabase)this.proposalTree.getModel()).removeContainer((ProposalContainer)path.getLastPathComponent());
            }
        }
    }
}

