/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.czechaddress.gui;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.plugins.czechaddress.CzechAddressPlugin;
import org.openstreetmap.josm.plugins.czechaddress.MapUtils;
import org.openstreetmap.josm.plugins.czechaddress.StatusListener;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.AddressElement;
import org.openstreetmap.josm.plugins.czechaddress.gui.HalfCookedTreeModel;
import org.openstreetmap.josm.plugins.czechaddress.gui.UniversalTreeRenderer;
import org.openstreetmap.josm.plugins.czechaddress.intelligence.Match;
import org.openstreetmap.josm.plugins.czechaddress.intelligence.Reasoner;
import org.openstreetmap.josm.tools.ImageProvider;

public class ConflictResolver
extends ExtendedDialog
implements StatusListener {
    private Object selMainObj = null;
    private Object selBestFit = null;
    private Object selCandObj = null;
    private JTextField bestTextField;
    private JButton bestZoomButton;
    private JButton candReassignButton;
    private JTextField candTextField;
    private JButton candZoomButton;
    private JTree elemConflictTree;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTabbedPane jTabbedPane1;
    private JPanel mainPanel;
    private JTextField mainTextField;
    private JButton mainZoomButton;
    private JTree primConflictTree;

    public ConflictResolver() {
        super(Main.parent, "\u0158e\u0161en\u00ed konflikt\u016f", new String[0], true);
        this.initComponents();
        this.elemConflictTree.setModel(new ElemTreeModel());
        this.primConflictTree.setModel(new PrimTreeModel());
        this.elemConflictTree.setCellRenderer(new UniversalTreeRenderer());
        this.primConflictTree.setCellRenderer(new UniversalTreeRenderer());
        ImageIcon zoomIcon = ImageProvider.get((String)"zoom.png");
        this.mainZoomButton.setIcon(zoomIcon);
        this.mainZoomButton.setText("");
        this.bestZoomButton.setIcon(zoomIcon);
        this.bestZoomButton.setText("");
        this.candZoomButton.setIcon(zoomIcon);
        this.candZoomButton.setText("");
        this.setupDialog(this.mainPanel, new String[0]);
        this.setAlwaysOnTop(false);
        this.setModal(false);
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.candZoomButton = new JButton();
        this.bestZoomButton = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.jScrollPane1 = new JScrollPane();
        this.elemConflictTree = new JTree();
        this.jScrollPane2 = new JScrollPane();
        this.primConflictTree = new JTree();
        this.jLabel4 = new JLabel();
        this.mainTextField = new JTextField();
        this.bestTextField = new JTextField();
        this.jLabel5 = new JLabel();
        this.candTextField = new JTextField();
        this.candReassignButton = new JButton();
        this.jLabel6 = new JLabel();
        this.mainZoomButton = new JButton();
        this.getContentPane().setLayout(new GridLayout(1, 0));
        this.setDefaultCloseOperation(2);
        this.candZoomButton.setText("     ");
        this.candZoomButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConflictResolver.this.candZoomButtonActionPerformed(evt);
            }
        });
        this.bestZoomButton.setText("     ");
        this.bestZoomButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConflictResolver.this.bestZoomButtonActionPerformed(evt);
            }
        });
        this.elemConflictTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent evt) {
                ConflictResolver.this.treeValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.elemConflictTree);
        this.jTabbedPane1.addTab("Dle datab\u00e1ze", this.jScrollPane1);
        this.primConflictTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent evt) {
                ConflictResolver.this.treeValueChanged(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.primConflictTree);
        this.jTabbedPane1.addTab("Dle mapy", this.jScrollPane2);
        this.jLabel4.setText("Objekt v konfliktu:");
        this.mainTextField.setEditable(false);
        this.bestTextField.setEditable(false);
        this.jLabel5.setText("Nejlep\u0161\u00ed p\u0159i\u0159azen\u00ed:");
        this.candTextField.setEditable(false);
        this.candReassignButton.setText("P\u0159i\u0159adit");
        this.candReassignButton.setEnabled(false);
        this.candReassignButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConflictResolver.this.candReassignButtonActionPerformed(evt);
            }
        });
        this.jLabel6.setText("Probl\u00e9mov\u00fd element:");
        this.mainZoomButton.setText("     ");
        this.mainZoomButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConflictResolver.this.mainZoomButtonActionPerformed(evt);
            }
        });
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, mainPanelLayout.createSequentialGroup().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.jLabel5).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, mainPanelLayout.createSequentialGroup().addComponent(this.candTextField, -1, 232, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.candReassignButton)).addComponent(this.bestTextField, -1, 319, Short.MAX_VALUE).addComponent(this.mainTextField, -1, 319, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.mainZoomButton).addComponent(this.bestZoomButton).addComponent(this.candZoomButton))).addComponent(this.jTabbedPane1, -1, 525, Short.MAX_VALUE));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, mainPanelLayout.createSequentialGroup().addComponent(this.jTabbedPane1, -1, 199, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.mainTextField, -2, -1, -2).addComponent(this.mainZoomButton).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bestTextField, -2, -1, -2).addComponent(this.bestZoomButton).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.candReassignButton).addComponent(this.candTextField, -2, -1, -2).addComponent(this.candZoomButton).addComponent(this.jLabel6))));
        this.getContentPane().add(this.mainPanel);
        this.pack();
    }

    private void treeValueChanged(TreeSelectionEvent evt) {
        this.selMainObj = null;
        this.selBestFit = null;
        this.selCandObj = null;
        Reasoner r = CzechAddressPlugin.getReasoner();
        TreePath tp = evt.getPath();
        if (tp.getPathCount() >= 2) {
            this.selMainObj = tp.getPathComponent(1);
        }
        if (this.selMainObj instanceof AddressElement) {
            this.selBestFit = r.translate((AddressElement)this.selMainObj);
        } else if (this.selMainObj instanceof OsmPrimitive) {
            this.selBestFit = r.translate((OsmPrimitive)this.selMainObj);
        }
        this.mainTextField.setText(AddressElement.getName(this.selMainObj));
        this.bestTextField.setText(AddressElement.getName(this.selBestFit));
        if (tp.getPathCount() >= 3) {
            this.selCandObj = tp.getPathComponent(2);
        }
        this.candTextField.setText(AddressElement.getName(this.selCandObj));
        if (this.selCandObj != null) {
            if (this.selBestFit == null) {
                this.bestTextField.setText("\u017e\u00e1dn\u00fd neexistuje, objekty v konfliktu jsou rovnocenn\u00e9");
            }
            this.candReassignButton.setEnabled(true);
        } else {
            this.candReassignButton.setEnabled(false);
        }
        this.mainZoomButton.setEnabled(this.selMainObj instanceof OsmPrimitive);
        this.bestZoomButton.setEnabled(this.selBestFit instanceof OsmPrimitive);
        this.candZoomButton.setEnabled(this.selCandObj instanceof OsmPrimitive);
    }

    private void mainZoomButtonActionPerformed(ActionEvent evt) {
        assert (this.selMainObj instanceof OsmPrimitive);
        MapUtils.zoomTo((OsmPrimitive)this.selMainObj);
    }

    private void bestZoomButtonActionPerformed(ActionEvent evt) {
        assert (this.selBestFit instanceof OsmPrimitive);
        MapUtils.zoomTo((OsmPrimitive)this.selBestFit);
    }

    private void candZoomButtonActionPerformed(ActionEvent evt) {
        assert (this.selCandObj instanceof OsmPrimitive);
        MapUtils.zoomTo((OsmPrimitive)this.selCandObj);
    }

    private void candReassignButtonActionPerformed(ActionEvent evt) {
        Reasoner r = CzechAddressPlugin.getReasoner();
        if (this.selMainObj instanceof OsmPrimitive && this.selCandObj instanceof AddressElement) {
            List<Match> competitors;
            Match best = r.findMatch((AddressElement)this.selBestFit);
            if (best != null) {
                best.qualityChanged();
            }
            if ((competitors = r.getConflicts((OsmPrimitive)this.selMainObj)) != null) {
                for (Match competitor : competitors) {
                    competitor.qualityChanged();
                }
            }
            r.overwriteMatch((AddressElement)this.selCandObj, (OsmPrimitive)this.selMainObj);
        } else if (this.selMainObj instanceof AddressElement && this.selCandObj instanceof OsmPrimitive) {
            List<Match> competitors;
            Match best = r.findMatch((OsmPrimitive)this.selBestFit);
            if (best != null) {
                best.qualityChanged();
            }
            if ((competitors = r.getConflicts((AddressElement)this.selMainObj)) != null) {
                for (Match competitor : competitors) {
                    competitor.qualityChanged();
                }
            }
            r.overwriteMatch((AddressElement)this.selMainObj, (OsmPrimitive)this.selCandObj);
        } else assert (false);
    }

    public void pluginStatusChanged(int message) {
        if (message == 3) {
            this.setVisible(true);
            ((HalfCookedTreeModel)this.elemConflictTree.getModel()).notifyAllListeners();
            ((HalfCookedTreeModel)this.primConflictTree.getModel()).notifyAllListeners();
            this.elemConflictTree.setModel(new ElemTreeModel());
            this.primConflictTree.setModel(new PrimTreeModel());
        }
    }

    private class PrimTreeModel
    extends HalfCookedTreeModel {
        public PrimTreeModel() {
            this.root = "Podle objek\u016f datab\u00e1ze";
        }

        public Object getChild(Object parent, int index) {
            try {
                Reasoner r = CzechAddressPlugin.getReasoner();
                if (parent == this.root) {
                    return r.getPrimitivesInConflict().get(index);
                }
                if (parent instanceof OsmPrimitive) {
                    return r.getConflicts((OsmPrimitive)((OsmPrimitive)parent)).get((int)index).elem;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        public int getChildCount(Object parent) {
            try {
                Reasoner r = CzechAddressPlugin.getReasoner();
                if (parent == this.root) {
                    return r.getPrimitivesInConflict().size();
                }
                if (parent instanceof OsmPrimitive) {
                    return r.getConflicts((OsmPrimitive)parent).size();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return 0;
        }

        public int getIndexOfChild(Object parent, Object child) {
            try {
                Reasoner r = CzechAddressPlugin.getReasoner();
                if (parent == this.root) {
                    return r.getPrimitivesInConflict().indexOf(child);
                }
                if (parent instanceof OsmPrimitive) {
                    return r.getConflicts((OsmPrimitive)parent).indexOf(child);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return -1;
        }
    }

    private class ElemTreeModel
    extends HalfCookedTreeModel {
        public ElemTreeModel() {
            this.root = "Konflikty podle objekt\u016f v datab\u00e1zi";
        }

        public Object getChild(Object parent, int index) {
            try {
                Reasoner r = CzechAddressPlugin.getReasoner();
                if (parent == this.root) {
                    return r.getElementsInConflict().get(index);
                }
                if (parent instanceof AddressElement) {
                    return r.getConflicts((AddressElement)((AddressElement)parent)).get((int)index).prim;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        public int getChildCount(Object parent) {
            try {
                Reasoner r = CzechAddressPlugin.getReasoner();
                if (parent == this.root) {
                    return r.getElementsInConflict().size();
                }
                if (parent instanceof AddressElement) {
                    return r.getConflicts((AddressElement)parent).size();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return 0;
        }

        public int getIndexOfChild(Object parent, Object child) {
            try {
                Reasoner r = CzechAddressPlugin.getReasoner();
                if (parent == this.root) {
                    return r.getElementsInConflict().indexOf(child);
                }
                if (parent instanceof AddressElement) {
                    return r.getConflicts((AddressElement)parent).indexOf(child);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return -1;
        }
    }
}

