/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.czechaddress.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class SplitAreaByEmptyWayAction
extends JosmAction {
    public SplitAreaByEmptyWayAction() {
        super(I18n.tr((String)"Split area"), "splitarea.png", I18n.tr((String)"Splits an area by an untagged way."), Shortcut.registerShortcut((String)"tools:splitarea", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Split area")}), (int)83, (int)2), true);
    }

    public void actionPerformed(ActionEvent e) {
        Collection selectedWays = Main.ds.getSelectedWays();
        Collection newSelection = Main.ds.getSelected();
        block0: for (OsmPrimitive prim : selectedWays) {
            if (!((Way)prim).isClosed()) continue;
            Way area = (Way)prim;
            for (OsmPrimitive prim2 : Main.ds.allNonDeletedPrimitives()) {
                if (!(prim2 instanceof Way) || prim2.equals((Object)prim)) continue;
                Way border = (Way)prim2;
                if (border.nodes.size() == 0 || border.keySet().size() > 0 || !area.nodes.contains(border.firstNode()) || !area.nodes.contains(border.lastNode())) continue;
                Way newArea1 = new Way();
                Way newArea2 = new Way();
                int errorCode = this.splitArea(area, border, newArea1, newArea2);
                if (errorCode == 2) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"The selected area cannot be splitted, because it is a member of some relation.\nRemove the area from the relation before splitting it."));
                    continue block0;
                }
                if (errorCode != 0) continue;
                Main.ds.addPrimitive((OsmPrimitive)newArea1);
                Main.ds.addPrimitive((OsmPrimitive)newArea2);
                area.delete(true);
                border.delete(true);
                newSelection.remove(area);
                newSelection.remove(border);
                newSelection.add(newArea1);
                newSelection.add(newArea2);
                continue block0;
            }
        }
        Main.ds.setSelected(newSelection);
    }

    private int splitArea(Way area, Way border, Way newArea1, Way newArea2) {
        int index2;
        Way tempBorder = new Way(border);
        int index1 = area.nodes.indexOf(tempBorder.firstNode());
        if (index1 == (index2 = area.nodes.indexOf(tempBorder.lastNode()))) {
            return 1;
        }
        if (index1 > index2) {
            Collections.reverse(tempBorder.nodes);
            index1 = area.nodes.indexOf(tempBorder.firstNode());
            index2 = area.nodes.indexOf(tempBorder.lastNode());
        }
        for (Relation relation : Main.ds.relations) {
            for (RelationMember areaMember : relation.members) {
                if (!area.equals((Object)areaMember.member)) continue;
                return 2;
            }
        }
        for (String key : area.keySet()) {
            newArea1.put(key, area.get(key));
            newArea2.put(key, area.get(key));
        }
        newArea1.nodes.addAll(area.nodes.subList(0, index1));
        newArea1.nodes.addAll(tempBorder.nodes);
        newArea1.nodes.addAll(area.nodes.subList(index2, area.nodes.size() - 1));
        newArea1.nodes.add(area.nodes.get(0));
        Collections.reverse(tempBorder.nodes);
        newArea2.nodes.addAll(area.nodes.subList(index1, index2));
        newArea2.nodes.addAll(tempBorder.nodes);
        newArea2.nodes.add(area.nodes.get(index1));
        this.removeDuplicateNodesFromWay(newArea1);
        this.removeDuplicateNodesFromWay(newArea2);
        return 0;
    }

    void removeDuplicateNodesFromWay(Way w) {
        int i = 0;
        while (i < w.nodes.size() - 1) {
            if (((Node)w.nodes.get(i)).equals(w.nodes.get(i + 1))) {
                w.nodes.remove(i);
                continue;
            }
            ++i;
        }
    }
}

