/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.czechaddress;

import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.IconToggleButton;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.czechaddress.DatabaseLoadException;
import org.openstreetmap.josm.plugins.czechaddress.StatusListener;
import org.openstreetmap.josm.plugins.czechaddress.actions.ConflictResolveAction;
import org.openstreetmap.josm.plugins.czechaddress.actions.FactoryAction;
import org.openstreetmap.josm.plugins.czechaddress.actions.GroupManipulatorAction;
import org.openstreetmap.josm.plugins.czechaddress.actions.PointManipulatorAction;
import org.openstreetmap.josm.plugins.czechaddress.actions.SplitAreaByEmptyWayAction;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.AddressElement;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.Database;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.ElementWithStreets;
import org.openstreetmap.josm.plugins.czechaddress.addressdatabase.House;
import org.openstreetmap.josm.plugins.czechaddress.gui.ConflictResolver;
import org.openstreetmap.josm.plugins.czechaddress.gui.FactoryDialog;
import org.openstreetmap.josm.plugins.czechaddress.gui.LocationSelector;
import org.openstreetmap.josm.plugins.czechaddress.intelligence.Reasoner;
import org.openstreetmap.josm.plugins.czechaddress.intelligence.SelectionMonitor;
import org.openstreetmap.josm.plugins.czechaddress.parser.MvcrParser;

public class CzechAddressPlugin
extends Plugin
implements StatusListener {
    JMenu czechMenu;
    List<JMenuItem> menuItems = new ArrayList<JMenuItem>();
    List<AbstractButton> pluginButtons = new ArrayList<AbstractButton>();
    private static Reasoner mainReasoner = null;
    private static Database mainDatabase = null;
    public SelectionMonitor selectionMonitor = null;
    public static FactoryDialog factoryDialog = null;
    public static ConflictResolver conflictResolver = null;
    private static String pluginDir = null;
    private static ElementWithStreets location = null;
    private static List<StatusListener> listeners = new ArrayList<StatusListener>();

    public CzechAddressPlugin() {
        pluginDir = this.getPluginDir();
        factoryDialog = FactoryDialog.getInstance();
        conflictResolver = new ConflictResolver();
        CzechAddressPlugin.addStatusListener(this);
        CzechAddressPlugin.addStatusListener(conflictResolver);
        MainMenu.add((JMenu)Main.main.menu.toolsMenu, (JosmAction)new SplitAreaByEmptyWayAction());
        mainDatabase = new Database();
        final MvcrParser parser = new MvcrParser();
        parser.setTargetDatabase(mainDatabase);
        parser.setStorageDir(pluginDir);
        Thread t = new Thread(){

            public void run() {
                super.run();
                try {
                    parser.fillDatabase();
                    CzechAddressPlugin.broadcastStatusChanged(4);
                }
                catch (DatabaseLoadException dle) {
                    dle.printStackTrace();
                    System.err.println("CzechAddress: Selhalo na\u010dten\u00ed datab\u00e1ze. Plugin je neaktivn\u00ed.");
                }
            }
        };
        t.setPriority(1);
        t.start();
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        super.mapFrameInitialized(oldFrame, newFrame);
        if (newFrame == null) {
            return;
        }
        newFrame.addToggleDialog((ToggleDialog)FactoryDialog.getInstance());
        newFrame.addMapMode(new IconToggleButton((Action)((Object)new FactoryAction(newFrame))));
    }

    public static Reasoner getReasoner() {
        return mainReasoner;
    }

    public static Database getDatabase() {
        return mainDatabase;
    }

    public static void initReasoner() {
        List<House> tmp1 = location.getAllHouses();
        ArrayList<AddressElement> tmp2 = new ArrayList<AddressElement>(tmp1.size());
        for (House h : tmp1) {
            tmp2.add(h);
        }
        mainReasoner = new Reasoner(tmp2);
        mainReasoner.addPrimitives(Main.ds.allPrimitives());
    }

    public static ElementWithStreets getLocation() {
        if (location == null) {
            CzechAddressPlugin.changeLocation();
        }
        return location;
    }

    public static void changeLocation() {
        ElementWithStreets newLocation = LocationSelector.selectLocation();
        if (newLocation != null && newLocation != location) {
            location = newLocation;
            CzechAddressPlugin.broadcastStatusChanged(1);
            CzechAddressPlugin.initReasoner();
        }
    }

    public static void addStatusListener(StatusListener l) {
        if (!listeners.contains(l)) {
            listeners.add(l);
        }
    }

    public static void removeStatusListener(StatusListener l) {
        listeners.remove(l);
    }

    public static void broadcastStatusChanged(int statusMessage) {
        for (StatusListener l : listeners) {
            l.pluginStatusChanged(statusMessage);
        }
    }

    public void pluginStatusChanged(int message) {
        if (message == 4) {
            this.czechMenu = Main.main.menu.addMenu("Adresy", 65, 4);
            this.menuItems.add(MainMenu.add((JMenu)this.czechMenu, (JosmAction)new PointManipulatorAction()));
            this.menuItems.add(MainMenu.add((JMenu)this.czechMenu, (JosmAction)new GroupManipulatorAction()));
            this.menuItems.add(MainMenu.add((JMenu)this.czechMenu, (JosmAction)new ConflictResolveAction()));
            return;
        }
    }
}

