/*
 * Decompiled with CFR 0.152.
 */
package wmsplugin;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileFilter;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Date;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import javax.imageio.ImageIO;
import org.openstreetmap.josm.Main;
import wmsplugin.WMSPlugin;

public class Cache {
    final File dir;
    private final long expire = Main.pref.getInteger("wmsplugin.cache.expire", 432000000);
    private final long maxsize = Main.pref.getInteger("wmsplugin.cache.size", 40000000);
    private boolean disabled = false;
    private final int cleanUpThreshold = 20;
    private final int cleanUpInterval = 5;

    Cache() {
        this(Main.pref.get("wmsplugin.cache.path", WMSPlugin.getPrefsPath() + "cache"));
    }

    Cache(String working_dir) {
        this.dir = new File(working_dir);
        try {
            this.dir.mkdirs();
        }
        catch (Exception e) {
            this.disabled = true;
        }
        if (this.expire <= 0L || this.maxsize <= 0L) {
            this.disabled = true;
        }
    }

    public BufferedImage getImg(String ident) {
        if (this.disabled) {
            return null;
        }
        try {
            File img = this.getPath(ident);
            if (!img.exists()) {
                return null;
            }
            if (img.lastModified() < new Date().getTime() - this.expire) {
                img.delete();
                return null;
            }
            return ImageIO.read(img);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return null;
        }
    }

    public void saveImg(String ident, BufferedImage image) {
        if (this.disabled) {
            return;
        }
        try {
            ImageIO.write((RenderedImage)image, "png", this.getPath(ident));
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        this.checkCleanUp();
    }

    public BufferedImage saveImg(String ident, BufferedImage image, boolean passThrough) {
        this.saveImg(ident, image);
        return image;
    }

    public void checkCleanUp() {
        if (new Random().nextInt(5) == 0) {
            this.cleanUp();
        }
    }

    public void cleanUp() {
        if (this.disabled) {
            return;
        }
        TreeMap<Long, File> modtime = new TreeMap<Long, File>();
        long time = new Date().getTime() - this.expire;
        long dirsize = 0L;
        for (File f : this.getFiles()) {
            if (f.lastModified() < time) {
                f.delete();
                continue;
            }
            dirsize += f.length();
            modtime.put(f.lastModified(), f);
        }
        if (dirsize < this.maxsize) {
            return;
        }
        Set keySet = modtime.keySet();
        Iterator it = keySet.iterator();
        int i = 0;
        while (it.hasNext()) {
            ((File)modtime.get(it.next())).delete();
            if (++i % 20 != 0 || this.getDirSize() >= this.maxsize) continue;
            return;
        }
    }

    public void deleteSmallFiles(int size) {
        if (this.disabled) {
            return;
        }
        for (File f : this.getFiles()) {
            if (f.length() >= (long)size) continue;
            f.delete();
        }
    }

    private long getDirSize() {
        if (this.disabled) {
            return -1L;
        }
        long dirsize = 0L;
        for (File f : this.getFiles()) {
            dirsize += f.length();
        }
        return dirsize;
    }

    private File[] getFiles() {
        if (this.disabled) {
            return null;
        }
        return this.dir.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.getName().endsWith(".png");
            }
        });
    }

    private static String getUniqueFilename(String ident) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            BigInteger number = new BigInteger(1, md.digest(ident.getBytes()));
            return number.toString(16);
        }
        catch (Exception e) {
            ident = ident.replaceAll("[^a-zA-Z0-9]", "");
            ident = ident.replaceAll("[acegikmoqsuwy]", "");
            return ident.substring(ident.length() - 70);
        }
    }

    private File getPath(String ident) {
        return new File(this.dir, Cache.getUniqueFilename(ident) + ".png");
    }
}

