/*
 * Decompiled with CFR 0.152.
 */
package com.innovant.josm.jrt.core;

import com.innovant.josm.jrt.core.RoutingGraphDelegator;
import com.innovant.josm.jrt.core.RoutingProfile;
import com.innovant.josm.jrt.osm.OsmEdge;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jgrapht.Graph;
import org.jgrapht.alg.BellmanFordShortestPath;
import org.jgrapht.alg.DijkstraShortestPath;
import org.jgrapht.graph.AsUndirectedGraph;
import org.jgrapht.graph.DirectedWeightedMultigraph;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Way;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoutingGraph {
    private RoutingProfile routingProfile;
    private RouteType routeType;
    private DataSet data;
    static Logger logger = Logger.getLogger(RoutingGraph.class);
    public boolean graphState = false;
    private Graph<Node, OsmEdge> graph = null;
    private RoutingGraphDelegator rgDelegator = null;
    private Map<String, Double> waySpeeds;

    public RoutingGraph(DataSet data) {
        this.data = data;
        this.routeType = RouteType.SHORTEST;
        this.routingProfile = new RoutingProfile("default");
        this.routingProfile.setOnewayUse(true);
        this.setWaySpeeds(this.routingProfile.getWaySpeeds());
        logger.debug("Created RoutingGraph");
    }

    public void createGraph() {
        logger.debug("Creating Graph...");
        this.graph = new DirectedWeightedMultigraph<Node, OsmEdge>(OsmEdge.class);
        this.rgDelegator = new RoutingGraphDelegator(this.graph);
        this.rgDelegator.setRouteType(this.routeType);
        for (Way way : this.data.ways) {
            if (way == null || way.deleted || !this.isvalidWay(way)) continue;
            Node from = null;
            for (Node to : way.nodes) {
                if (to.deleted) continue;
                this.graph.addVertex(to);
                if (from != null) {
                    this.addEdge(way, from, to);
                    if (!this.isOneWay(way)) {
                        this.addEdge(way, to, from);
                    }
                }
                from = to;
            }
        }
        this.graph.vertexSet().size();
        logger.debug("End Create Graph");
        logger.debug("Vertex: " + this.graph.vertexSet().size());
        logger.debug("Edges: " + this.graph.edgeSet().size());
    }

    private void addEdge(Way way, Node from, Node to) {
        double length = from.coor.greatCircleDistance(to.coor);
        OsmEdge edge = new OsmEdge(way, from, to);
        edge.setSpeed(12.1);
        this.graph.addEdge(from, to, edge);
        double weight = this.getWeight(way, length);
        this.getWeight(edge, length);
        logger.debug("edge for way " + way.id + "(from node " + from.id + " to node " + to.id + ") has weight: " + weight);
        ((DirectedWeightedMultigraph)this.graph).setEdgeWeight(edge, weight);
    }

    private void getWeight(OsmEdge osmedge, double length) {
        osmedge.setLength(length);
        if (this.waySpeeds.containsKey(osmedge.getWay().get("highway"))) {
            osmedge.setSpeed(this.waySpeeds.get(osmedge.getWay().get("highway")));
        }
    }

    private double getWeight(Way way, double length) {
        double speed = 1.0;
        switch (this.routeType) {
            case SHORTEST: {
                if (!this.waySpeeds.containsKey("residential")) break;
                speed = this.waySpeeds.get("residential");
                break;
            }
            case FASTEST: {
                if (this.waySpeeds.containsKey(way.get("highway"))) {
                    speed = this.waySpeeds.get(way.get("highway"));
                }
                logger.debug("Speed=" + speed);
                break;
            }
        }
        return length / speed;
    }

    private boolean isOneWay(Way way) {
        return way.get("oneway") != null || "motorway".equals(way.get("highway"));
    }

    public boolean isvalidWay(Way way) {
        if (!way.isTagged()) {
            return false;
        }
        return way.get("highway") != null || way.get("junction") != null || way.get("service") != null;
    }

    public boolean isvalidNode(Node node) {
        return true;
    }

    public List<OsmEdge> applyAlgorithm(List<Node> nodes, Algorithm algorithm) {
        List<OsmEdge> path = new ArrayList<OsmEdge>();
        double totalWeight = 0.0;
        if (this.graph == null) {
            this.createGraph();
        }
        logger.debug("apply algorithm between nodes ");
        for (Node node : nodes) {
            logger.debug(node.id);
        }
        logger.debug("-----------------------------------");
        Graph<Node, OsmEdge> g = this.routingProfile.isOnewayUsed() ? this.graph : new AsUndirectedGraph<Node, OsmEdge>((DirectedWeightedMultigraph)this.graph);
        block0 : switch (algorithm) {
            case ROUTING_ALG_DIJKSTRA: {
                logger.debug("Using Dijkstra algorithm");
                DijkstraShortestPath<Node, OsmEdge> routingk = null;
                for (int index = 1; index < nodes.size(); ++index) {
                    routingk = new DijkstraShortestPath<Node, OsmEdge>(this.rgDelegator, nodes.get(index - 1), nodes.get(index));
                    if (routingk.getPathEdgeList() == null) {
                        logger.debug("no path found!");
                        break block0;
                    }
                    path.addAll(routingk.getPathEdgeList());
                    totalWeight += routingk.getPathLength();
                }
                break;
            }
            case ROUTING_ALG_BELLMANFORD: {
                logger.debug("Using Bellman Ford algorithm");
                for (int index = 1; index < nodes.size(); ++index) {
                    path = BellmanFordShortestPath.findPathBetween(this.rgDelegator, nodes.get(index - 1), nodes.get(index));
                    if (path != null) continue;
                    logger.debug("no path found!");
                    return null;
                }
                break;
            }
            default: {
                logger.debug("Wrong algorithm");
            }
        }
        logger.debug("shortest path found: " + path + "\nweight: " + totalWeight);
        return path;
    }

    public int getVertexCount() {
        int value = 0;
        if (this.graph != null) {
            value = this.graph.vertexSet().size();
        }
        return value;
    }

    public int getEdgeCount() {
        int value = 0;
        if (this.graph != null) {
            value = this.graph.edgeSet().size();
        }
        return value;
    }

    public void setTypeRoute(RouteType routetype) {
        this.routeType = routetype;
        this.rgDelegator.setRouteType(routetype);
    }

    public RouteType getTypeRoute() {
        return this.routeType;
    }

    public Map<String, Double> getWaySpeeds() {
        return this.waySpeeds;
    }

    public void setWaySpeeds(Map<String, Double> waySpeeds) {
        this.waySpeeds = waySpeeds;
    }

    public void resetGraph() {
        this.graph = null;
    }

    public RoutingProfile getRoutingProfile() {
        return this.routingProfile;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RouteType {
        FASTEST,
        SHORTEST;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Algorithm {
        ROUTING_ALG_DIJKSTRA,
        ROUTING_ALG_BELLMANFORD;

    }
}

