/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.globalsat;

import gnu.io.CommPortIdentifier;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.kaintoch.gps.globalsat.dg100.ByteHelper;
import org.kaintoch.gps.globalsat.dg100.Dg100Config;
import org.kaintoch.gps.globalsat.dg100.FileInfoRec;
import org.kaintoch.gps.globalsat.dg100.GpsRec;
import org.kaintoch.gps.globalsat.dg100.Response;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.WayPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalsatDg100 {
    public static final int TIMEOUT = 2000;
    public static final int TRACK_TYPE = 1;
    private static byte[] dg100CmdSwitch2Nmea = new byte[]{-96, -94, 0, 24, -127, 2, 1, 1, 0, 1, 1, 1, 5, 1, 1, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 37, -128, 0, 0, -80, -77};
    private static byte[] dg100CmdEnterGMouse = new byte[]{-96, -94, 0, 2, -68, 1, 0, -67, -80, -77};
    private static byte[] dg100CmdDelFile = new byte[]{-96, -94, 0, 3, -70, -1, -1, 2, -72, -80, -77};
    private static byte[] dg100CmdGetFileInfo = new byte[]{-96, -94, 0, 3, -69, 0, 0, 0, -69, -80, -77};
    private static byte[] dg100CmdGetGpsRecs = new byte[]{-96, -94, 0, 3, -75, 0, 2, 0, -73, -80, -77};
    private static byte[] dg100CmdGetConfig = new byte[]{-96, -94, 0, 1, -73, 0, -73, -80, -77};
    private static byte[] dg100CmdSetConfig = new byte[]{-96, -94, 0, 42, -72, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, -24, 0, 0, 3, -24, 0, 0, 3, -24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, -80, -77};
    private static byte[] dg100CmdGetId = new byte[]{-96, -94, 0, 1, -65, 0, -65, -80, -77};
    private static byte[] dg100CmdSetId = new byte[]{-96, -94, 0, 9, -64, 0, 0, 0, 0, 0, 0, 0, 0, 0, -64, -80, -77};
    private byte[] response = new byte[65536];
    private CommPortIdentifier portIdentifier;
    private SerialPort port = null;
    private boolean cancelled = false;

    public GlobalsatDg100(CommPortIdentifier portId) {
        this.portIdentifier = portId;
    }

    public void cancel() {
        this.cancelled = true;
        this.disconnect();
    }

    public GpxData readData() throws ConnectionException {
        GpxData result = null;
        int cnt = 0;
        this.cancelled = false;
        if (this.port == null) {
            this.connect();
        }
        Main.pleaseWaitDlg.progress.setValue(0);
        List<FileInfoRec> fileInfoList = this.readFileInfoList();
        List<GpsRec> gpsRecList = this.readGpsRecList(fileInfoList);
        Main.pleaseWaitDlg.progress.setMaximum(gpsRecList.size());
        if (gpsRecList.size() > 0) {
            GpsRec last = null;
            GpxTrack trk = new GpxTrack();
            ArrayList<WayPoint> seg = new ArrayList<WayPoint>(100);
            result = new GpxData();
            result.tracks.add(trk);
            trk.trackSegs.add(seg);
            for (GpsRec r : gpsRecList) {
                if (this.cancelled) {
                    return result;
                }
                WayPoint p = this.wayPointFrom(r);
                if (r.equals(last)) {
                    result.waypoints.add(p);
                } else {
                    seg.add(p);
                }
                last = r;
                Main.pleaseWaitDlg.progress.setValue(cnt++);
            }
        }
        return result;
    }

    private WayPoint wayPointFrom(GpsRec r) {
        LatLon l = new LatLon(r.getLatitude(), r.getLongitude());
        WayPoint result = new WayPoint(l);
        result.attr.put("time", "" + r.getStringZuluTime());
        result.attr.put("speed", "" + r.getSpeed());
        if (r.getDg100TypeOfCurRec() > 1) {
            result.attr.put("ele", "" + r.getAltitude());
        }
        return result;
    }

    public void deleteData() throws ConnectionException {
        if (this.port == null) {
            this.connect();
        }
        try {
            Response response = this.sendCmdDelFiles();
        }
        catch (Exception e) {
            throw new ConnectionException(e);
        }
    }

    public void disconnect() {
        if (this.port != null) {
            this.port.close();
            this.port = null;
        }
    }

    private void connect() throws ConnectionException {
        try {
            this.port = (SerialPort)this.portIdentifier.open("DG100", 2000);
            this.port.setSerialPortParams(115200, 8, 2, 0);
            this.port.notifyOnOutputEmpty(false);
        }
        catch (PortInUseException e) {
            throw new ConnectionException(e);
        }
        catch (UnsupportedCommOperationException e) {
            throw new ConnectionException(e);
        }
    }

    private List<FileInfoRec> readFileInfoList() throws ConnectionException {
        int nextIdx = 0;
        ArrayList<FileInfoRec> result = new ArrayList<FileInfoRec>(64);
        try {
            do {
                Response response = this.sendCmdGetFileInfo(nextIdx);
                nextIdx = response.getNextIdx();
                result.addAll(response.getRecs());
            } while (nextIdx > 0);
            return result;
        }
        catch (Exception e) {
            throw new ConnectionException(e);
        }
    }

    public List<GpsRec> readGpsRecList(List<FileInfoRec> fileInfoList) throws ConnectionException {
        int cnt = 0;
        ArrayList<GpsRec> result = new ArrayList<GpsRec>(200);
        try {
            for (FileInfoRec fileInfoRec : fileInfoList) {
                ++cnt;
                Response response = this.sendCmdGetGpsRecs(fileInfoRec.getIdx());
                result.addAll(response.getRecs());
            }
            return result;
        }
        catch (Exception e) {
            throw new ConnectionException(e);
        }
    }

    private Response sendCmdDelFiles() throws IOException, UnsupportedCommOperationException {
        System.out.println("deleting data...");
        int len = this.sendCmd(dg100CmdDelFile, this.response, -1);
        return Response.parseResponse(this.response, len);
    }

    private Response sendCmdGetFileInfo(int idx) throws IOException, UnsupportedCommOperationException {
        byte[] src = dg100CmdGetFileInfo;
        ByteBuffer buf = ByteBuffer.wrap(src);
        buf.position(5);
        buf.putShort((short)idx);
        this.updateCheckSum(buf);
        int len = this.sendCmd(src, this.response, -1);
        return Response.parseResponse(this.response, len);
    }

    private Response sendCmdGetConfig() throws IOException, UnsupportedCommOperationException {
        byte[] src = dg100CmdGetConfig;
        int len = this.sendCmd(src, this.response, -1);
        return Response.parseResponse(this.response, len);
    }

    public Dg100Config getConfig() throws ConnectionException {
        try {
            if (this.port == null) {
                this.connect();
            }
            Response response = this.sendCmdGetConfig();
            return response.getConfig();
        }
        catch (Exception e) {
            throw new ConnectionException(e);
        }
    }

    private void sendCmdSetConfig(Dg100Config config) throws IOException, UnsupportedCommOperationException {
        byte[] src = dg100CmdSetConfig;
        ByteBuffer buf = ByteBuffer.wrap(src);
        if (config != null) {
            config.write(buf);
        }
        this.updateCheckSum(buf);
        int len = this.sendCmd(src, this.response, -1);
        Response.parseResponse(this.response, len);
    }

    public void setConfig(Dg100Config conf) throws ConnectionException {
        try {
            this.sendCmdSetConfig(conf);
        }
        catch (Exception e) {
            throw new ConnectionException(e);
        }
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    private Response sendCmdGetGpsRecs(int idx) throws IOException, UnsupportedCommOperationException {
        byte[] src = dg100CmdGetGpsRecs;
        ByteBuffer buf = ByteBuffer.wrap(src);
        buf.position(5);
        buf.putShort((short)idx);
        this.updateCheckSum(buf);
        int len = this.sendCmd(src, this.response, 2074);
        return Response.parseResponse(this.response, len);
    }

    private void updateCheckSum(ByteBuffer buf) {
        buf.position(2);
        int len = buf.getShort();
        int sum = 0;
        for (int ii = 0; ii < len; ++ii) {
            sum += ByteHelper.byte2IntUnsigned(buf.get());
        }
        buf.putShort((short)(sum &= Short.MAX_VALUE));
    }

    private int sendCmd(byte[] cmdAndArgs, byte[] response, int bytesToRead) throws IOException, UnsupportedCommOperationException {
        int cntBytTot = 0;
        OutputStream outputStream = null;
        outputStream = this.port.getOutputStream();
        outputStream.write(cmdAndArgs);
        outputStream.flush();
        cntBytTot = this.readResponse(response, bytesToRead);
        return cntBytTot;
    }

    private int readResponse(byte[] response, int bytesToRead) throws IOException, UnsupportedCommOperationException {
        byte[] readBuffer = new byte[200];
        int responsePos = 0;
        boolean headerReceived = false;
        this.port.enableReceiveTimeout(2000);
        int cntBytTot = 0;
        InputStream inputStream = this.port.getInputStream();
        if (inputStream != null) {
            ByteBuffer buf = ByteBuffer.wrap(response);
            this.port.enableReceiveThreshold(2);
            boolean a0A2Received = false;
            while (!a0A2Received) {
                response[0] = response[1];
                int rcvd = inputStream.read(response, 1, 1);
                if (rcvd == 0) {
                    return 0;
                }
                a0A2Received = response[0] == -96 && response[1] == -94;
            }
            responsePos = 2;
            cntBytTot = 2;
            this.port.enableReceiveThreshold(2);
            while (bytesToRead < 0 || bytesToRead >= 0 && cntBytTot < bytesToRead) {
                int cntBytAct = 0;
                cntBytAct = inputStream.read(readBuffer);
                responsePos = ByteHelper.copyByteArr2ByteArr(readBuffer, 0, cntBytAct, response, responsePos);
                if (!headerReceived && (cntBytTot += cntBytAct) >= 4) {
                    if (bytesToRead == -1) {
                        buf.position(2);
                        bytesToRead = buf.getShort() + 4;
                    }
                    this.port.enableReceiveThreshold(1);
                    headerReceived = true;
                }
                if (cntBytAct != 0) continue;
                break;
            }
            return cntBytTot > bytesToRead ? bytesToRead : cntBytTot;
        }
        return -1;
    }

    public class ConnectionException
    extends Exception {
        ConnectionException(Exception cause) {
            super(cause);
        }

        ConnectionException(String msg) {
            super(msg);
        }
    }
}

