/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.classextension.internal;

import org.easymock.classextension.internal.DefaultClassInstantiator;
import org.easymock.classextension.internal.IClassInstantiator;
import org.easymock.classextension.internal.SunClassInstantiator;

public class ClassInstantiatorFactory {
    private ClassInstantiatorFactory() {
    }

    public static String getJVM() {
        return System.getProperty("java.vm.specification.vendor");
    }

    public static String getJVMSpecificationVersion() {
        return System.getProperty("java.specification.version");
    }

    public static boolean isSunJVM() {
        return ClassInstantiatorFactory.getJVM().equals("Sun Microsystems Inc.");
    }

    public static boolean is1_3Specifications() {
        return ClassInstantiatorFactory.getJVMSpecificationVersion().equals("1.3");
    }

    public static IClassInstantiator getInstantiator() {
        if (ClassInstantiatorFactory.isSunJVM() && !ClassInstantiatorFactory.is1_3Specifications()) {
            return new SunClassInstantiator();
        }
        return new DefaultClassInstantiator();
    }
}

