/*
 * Decompiled with CFR 0.152.
 */
package com.innovant.josm.plugin.routing.actions;

import com.innovant.josm.plugin.routing.RoutingLayer;
import com.innovant.josm.plugin.routing.RoutingPlugin;
import com.innovant.josm.plugin.routing.gui.RoutingDialog;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import org.apache.log4j.Logger;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class AddRouteNodeAction
extends MapMode {
    private static final long serialVersionUID = 1L;
    static Logger logger = Logger.getLogger(AddRouteNodeAction.class);
    private RoutingDialog routingDialog = RoutingPlugin.getInstance().getRoutingDialog();

    public AddRouteNodeAction(MapFrame mapFrame) {
        super(I18n.tr((String)"Routing"), "add", I18n.tr((String)"Click to add destination."), mapFrame, ImageProvider.getCursor((String)"crosshair", null));
    }

    public void enterMode() {
        super.enterMode();
        Main.map.mapView.addMouseListener((MouseListener)((Object)this));
    }

    public void exitMode() {
        super.exitMode();
        Main.map.mapView.removeMouseListener((MouseListener)((Object)this));
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 1) {
            Node node = null;
            if (Main.map.mapView.getActiveLayer() instanceof RoutingLayer) {
                RoutingLayer layer = (RoutingLayer)Main.map.mapView.getActiveLayer();
                node = layer.getNearestHighwayNode(e.getPoint());
                if (node == null) {
                    logger.debug("no selected node");
                    return;
                }
                logger.debug("selected node " + node);
                layer.getRoutingModel().addNode(node);
                this.routingDialog.addNode(node);
            }
        }
        Main.map.repaint();
    }
}

