/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.slippymap;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.openstreetmap.josm.plugins.slippymap.SlippyMapPreferences;
import org.openstreetmap.josm.tools.I18n;

public class SlippyMapTile {
    private Image tileImage;
    long timestamp;
    int x;
    int y;
    int z;
    private String metadata;

    public SlippyMapTile(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.timestamp = System.currentTimeMillis();
    }

    public String getMetadata() {
        return this.metadata;
    }

    public URL getImageURL() {
        try {
            return new URL(SlippyMapPreferences.getMapUrl() + "/" + this.z + "/" + this.x + "/" + this.y + ".png");
        }
        catch (MalformedURLException mfu) {
            mfu.printStackTrace();
            return null;
        }
    }

    public void loadImage() {
        URL imageURL = this.getImageURL();
        this.tileImage = Toolkit.getDefaultToolkit().createImage(imageURL);
        Toolkit.getDefaultToolkit().sync();
        this.timestamp = System.currentTimeMillis();
    }

    public Image getImage() {
        this.timestamp = System.currentTimeMillis();
        return this.tileImage;
    }

    public void dropImage() {
        this.tileImage = null;
    }

    public void loadMetadata() {
        try {
            URL dev = new URL("http://tah.openstreetmap.org/Tiles/info_short.php?x=" + this.x + "&y=" + this.y + "&z=" + this.z + "/layer=tile");
            URLConnection devc = dev.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(devc.getInputStream()));
            this.metadata = I18n.tr((String)in.readLine());
        }
        catch (Exception ex) {
            this.metadata = I18n.tr((String)("error loading metadata" + ex.toString()));
        }
    }

    public void requestUpdate() {
        try {
            URL dev = new URL("http://tah.openstreetmap.org/Request/create/?x=" + this.x + "&y=" + this.y + "&priority=1&src=slippymap_plugin");
            URLConnection devc = dev.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(devc.getInputStream()));
            this.timestamp = System.currentTimeMillis();
            this.metadata = I18n.tr((String)"requested: {0}", (Object[])new Object[]{I18n.tr((String)in.readLine())});
        }
        catch (Exception ex) {
            this.metadata = I18n.tr((String)"error requesting update");
        }
    }

    public long access_time() {
        return this.timestamp;
    }

    public boolean equals(Object o) {
        if (!(o instanceof SlippyMapTile)) {
            return false;
        }
        SlippyMapTile other = (SlippyMapTile)o;
        return this.x == other.x && this.y == other.y && this.z == other.z;
    }
}

