/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.piclayer;

import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenu;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.IconToggleButton;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.piclayer.HelpAction;
import org.openstreetmap.josm.plugins.piclayer.MovePictureAction;
import org.openstreetmap.josm.plugins.piclayer.NewLayerFromClipboardAction;
import org.openstreetmap.josm.plugins.piclayer.NewLayerFromFileAction;
import org.openstreetmap.josm.plugins.piclayer.PicLayerAbstract;
import org.openstreetmap.josm.plugins.piclayer.RotatePictureAction;
import org.openstreetmap.josm.plugins.piclayer.ScalePictureAction;

public class PicLayerPlugin
extends Plugin
implements Layer.LayerChangeListener {
    private JMenu m_menu = null;
    private IconToggleButton m_movePictureButton = null;
    private IconToggleButton m_rotatePictureButton = null;
    private IconToggleButton m_scalePictureButton = null;
    private NewLayerFromFileAction m_newFromFileAction = null;
    private NewLayerFromClipboardAction m_newFromClipAction = null;

    public PicLayerPlugin() {
        if (Main.main.menu != null) {
            MainMenu mainMenu = Main.main.menu;
            Main.main.menu.getClass();
            this.m_menu = mainMenu.addMenu("PicLayer", 73, 5);
        }
        if (this.m_menu != null) {
            this.m_newFromFileAction = new NewLayerFromFileAction();
            this.m_menu.add((Action)((Object)this.m_newFromFileAction));
            this.m_newFromClipAction = new NewLayerFromClipboardAction();
            this.m_menu.add((Action)((Object)this.m_newFromClipAction));
            this.m_menu.addSeparator();
            this.m_menu.add((Action)((Object)new HelpAction()));
            this.m_newFromFileAction.setEnabled(false);
            this.m_newFromClipAction.setEnabled(false);
        }
        Layer.listeners.add(this);
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        if (newFrame != null) {
            MovePictureAction movePictureAction = new MovePictureAction(newFrame);
            RotatePictureAction rotatePictureAction = new RotatePictureAction(newFrame);
            ScalePictureAction scalePictureAction = new ScalePictureAction(newFrame);
            this.m_movePictureButton = new IconToggleButton((Action)((Object)movePictureAction));
            this.m_rotatePictureButton = new IconToggleButton((Action)((Object)rotatePictureAction));
            this.m_scalePictureButton = new IconToggleButton((Action)((Object)scalePictureAction));
            newFrame.addMapMode(this.m_movePictureButton);
            newFrame.addMapMode(this.m_rotatePictureButton);
            newFrame.addMapMode(this.m_scalePictureButton);
            newFrame.toolGroup.add((AbstractButton)this.m_movePictureButton);
            newFrame.toolGroup.add((AbstractButton)this.m_rotatePictureButton);
            newFrame.toolGroup.add((AbstractButton)this.m_scalePictureButton);
            this.m_movePictureButton.setVisible(true);
            this.m_rotatePictureButton.setVisible(true);
            this.m_scalePictureButton.setVisible(true);
        }
    }

    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
        this.m_movePictureButton.setEnabled(newLayer instanceof PicLayerAbstract);
        this.m_rotatePictureButton.setEnabled(newLayer instanceof PicLayerAbstract);
        this.m_scalePictureButton.setEnabled(newLayer instanceof PicLayerAbstract);
    }

    public void layerAdded(Layer arg0) {
        this.m_newFromFileAction.setEnabled(true);
        this.m_newFromClipAction.setEnabled(true);
    }

    public void layerRemoved(Layer arg0) {
        boolean enable = Main.map.mapView.getAllLayers().size() != 0;
        this.m_newFromFileAction.setEnabled(enable);
        this.m_newFromClipAction.setEnabled(enable);
    }
}

