/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tageditor.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.openstreetmap.josm.plugins.tageditor.preset.Item;
import org.openstreetmap.josm.tools.I18n;

public class PresetItemListCellRenderer
extends JLabel
implements ListCellRenderer {
    private static final Logger logger = Logger.getLogger(PresetItemListCellRenderer.class.getName());
    private static final Font DEFAULT_FONT = new Font("SansSerif", 0, 10);
    public static final Color BG_COLOR_SELECTED = new Color(143, 170, 255);

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Item item = (Item)value;
        if (item == null) {
            this.setText(I18n.tr((String)"(none)"));
            this.setIcon(null);
        } else {
            if (isSelected) {
                this.setBackground(BG_COLOR_SELECTED);
            } else {
                this.setBackground(Color.WHITE);
            }
            this.setIcon(item.getIcon());
            StringBuilder sb = new StringBuilder();
            sb.append(item.getParent().getName()).append("/").append(item.getName());
            this.setText(sb.toString());
            this.setOpaque(true);
            this.setFont(DEFAULT_FONT);
        }
        return this;
    }
}

