/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.appbundler;

import com.oracle.appbundler.AppBundlerTask;
import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;

public class Runtime
extends FileSet {
    public File getDir() {
        File dir = super.getDir();
        try {
            return dir.getCanonicalFile();
        }
        catch (IOException e) {
            return dir;
        }
    }

    private void detectType() {
        boolean isJDK = new File(this.getDir(), "jre").isDirectory();
        if (isJDK) {
            this.appendIncludes(new String[]{"jre/lib/", "jreCOPYRIGHT", "jre/LICENSE", "jre/README", "jre/THIRDPARTYLICENSEREADME-JAVAFX.txt", "jre/THIRDPARTYLICENSEREADME.txt", "jre/Welcome.html"});
            this.appendExcludes(new String[]{"jre/lib/deploy/", "jre/lib/deploy.jar", "jre/lib/javaws.jar", "jre/lib/libdeploy.dylib", "jre/lib/libnpjp2.dylib", "jre/lib/plugin.jar", "jre/lib/security/javaws.policy"});
        } else {
            this.appendIncludes(new String[]{"lib/", "COPYRIGHT", "LICENSE", "README", "THIRDPARTYLICENSEREADME-JAVAFX.txt", "THIRDPARTYLICENSEREADME.txt", "Welcome.html"});
        }
    }

    void copyTo(File targetDir) throws IOException {
        this.detectType();
        File runtimeHomeDirectory = this.getDir();
        File runtimeContentsDirectory = runtimeHomeDirectory.getParentFile();
        File runtimeDirectory = runtimeContentsDirectory.getParentFile();
        File pluginDirectory = new File(targetDir, runtimeDirectory.getName());
        pluginDirectory.mkdir();
        File pluginContentsDirectory = new File(pluginDirectory, runtimeContentsDirectory.getName());
        pluginContentsDirectory.mkdir();
        File runtimeMacOSDirectory = new File(runtimeContentsDirectory, "MacOS");
        AppBundlerTask.copy(runtimeMacOSDirectory, new File(pluginContentsDirectory, runtimeMacOSDirectory.getName()));
        File runtimeInfoPlistFile = new File(runtimeContentsDirectory, "Info.plist");
        AppBundlerTask.copy(runtimeInfoPlistFile, new File(pluginContentsDirectory, runtimeInfoPlistFile.getName()));
        File pluginHomeDirectory = new File(pluginContentsDirectory, runtimeHomeDirectory.getName());
        DirectoryScanner directoryScanner = this.getDirectoryScanner(this.getProject());
        String[] includedFiles = directoryScanner.getIncludedFiles();
        for (int i = 0; i < includedFiles.length; ++i) {
            String includedFile = includedFiles[i];
            File source = new File(runtimeHomeDirectory, includedFile);
            File destination = new File(pluginHomeDirectory, includedFile);
            AppBundlerTask.copy(source, destination);
        }
    }
}

