/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.osb.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.plugins.osb.gui.historycombobox.HistoryChangedListener;
import org.openstreetmap.josm.plugins.osb.gui.historycombobox.SuggestingJHistoryComboBox;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextInputDialog
extends JDialog {
    private JLabel lblIcon;
    private JButton btnCancel;
    private JButton btnOk;
    private JPanel pnlButtons;
    private SuggestingJHistoryComboBox input;
    private JLabel lblText;
    private JPanel pnlMain;
    private String value = null;

    private TextInputDialog() {
        this.initGUI();
        this.initListeners();
    }

    private void initListeners() {
        this.input.getEditor().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TextInputDialog.this.okPressed();
            }
        });
        this.btnOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TextInputDialog.this.okPressed();
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TextInputDialog.this.dispose();
            }
        });
    }

    private void okPressed() {
        this.value = this.input.getText();
        this.input.addCurrentItemToHistory();
        this.dispose();
    }

    private void initGUI() {
        BorderLayout thisLayout = new BorderLayout();
        this.getContentPane().setLayout(thisLayout);
        thisLayout.setHgap(5);
        thisLayout.setVgap(5);
        this.pnlMain = new JPanel();
        GridBagLayout pnlMainLayout = new GridBagLayout();
        pnlMainLayout.rowWeights = new double[]{0.1, 0.1, 0.1};
        pnlMainLayout.rowHeights = new int[]{7, 7, 7};
        pnlMainLayout.columnWeights = new double[]{0.1, 0.1};
        pnlMainLayout.columnWidths = new int[]{7, 7};
        this.getContentPane().add((Component)this.pnlMain, "Center");
        this.pnlMain.setLayout(pnlMainLayout);
        this.pnlMain.setPreferredSize(new Dimension(487, 132));
        this.lblIcon = new JLabel();
        this.pnlMain.add((Component)this.lblIcon, new GridBagConstraints(0, 0, 1, 3, 0.0, 0.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
        this.lblIcon.setVerticalAlignment(1);
        this.lblIcon.setVerticalTextPosition(1);
        this.lblText = new JLabel();
        this.pnlMain.add((Component)this.lblText, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.input = new SuggestingJHistoryComboBox();
        this.pnlMain.add((Component)this.input, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.input.setSize(503, 22);
        this.pnlButtons = new JPanel();
        FlowLayout pnlButtonsLayout = new FlowLayout();
        pnlButtonsLayout.setAlignment(2);
        this.pnlMain.add((Component)this.pnlButtons, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 14, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.pnlButtons.setLayout(pnlButtonsLayout);
        this.btnOk = new JButton();
        this.pnlButtons.add(this.btnOk);
        this.btnOk.setText(I18n.tr((String)"OK"));
        this.btnOk.setPreferredSize(new Dimension(100, 25));
        this.btnCancel = new JButton();
        this.pnlButtons.add(this.btnCancel);
        this.btnCancel.setText(I18n.tr((String)"Cancel"));
        this.btnCancel.setPreferredSize(new Dimension(100, 25));
        this.setDefaultCloseOperation(2);
    }

    public static String showDialog(JComponent parent, String title, String text, List<String> history, HistoryChangedListener l) {
        return TextInputDialog.showDialog(parent, title, text, null, history, l);
    }

    public static String showDialog(JComponent parent, String title, String description, Icon icon, List<String> history, HistoryChangedListener l) {
        TextInputDialog tid = new TextInputDialog();
        tid.setTitle(title);
        tid.setSize(new Dimension(500, 180));
        tid.setDescription(description);
        tid.setHistory(history);
        tid.addHistoryChangedListener(l);
        tid.setModal(true);
        tid.setIcon(icon);
        Point p = new Point(0, 0);
        SwingUtilities.convertPointToScreen(p, parent);
        int x = (int)(p.getX() + (double)(parent.getWidth() - tid.getWidth()) / 2.0);
        int y = (int)(p.getY() + (double)(parent.getHeight() - tid.getHeight()) / 2.0);
        tid.setLocation(x, y);
        tid.setVisible(true);
        return tid.getValue();
    }

    private String getValue() {
        return this.value;
    }

    public void setDescription(String text) {
        this.lblText.setText(text);
    }

    public void setHistory(List<String> history) {
        this.input.setHistory(history);
        this.input.setText("");
        this.value = null;
    }

    public void addHistoryChangedListener(HistoryChangedListener l) {
        this.input.addHistoryChangedListener(l);
    }

    public void setIcon(Icon icon) {
        this.lblIcon.setIcon(icon);
    }
}

