/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.osb.gui.action;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JComponent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.osb.OsbPlugin;
import org.openstreetmap.josm.plugins.osb.api.CloseAction;
import org.openstreetmap.josm.plugins.osb.api.EditAction;
import org.openstreetmap.josm.plugins.osb.gui.action.OsbAction;
import org.openstreetmap.josm.plugins.osb.gui.dialogs.TextInputDialog;
import org.openstreetmap.josm.plugins.osb.gui.historycombobox.HistoryChangedListener;
import org.openstreetmap.josm.plugins.osb.gui.historycombobox.StringUtils;
import org.openstreetmap.josm.tools.I18n;

public class CloseIssueAction
extends OsbAction {
    private static final long serialVersionUID = 1L;
    private CloseAction closeAction = new CloseAction();
    private EditAction commentAction = new EditAction();

    public CloseIssueAction() {
        super(I18n.tr((String)"Mark as done"));
    }

    protected void doActionPerformed(ActionEvent e) throws Exception {
        List<String> history = StringUtils.stringToList(Main.pref.get("osb.comment.history"), "\u00a7\u00a7\u00a7");
        HistoryChangedListener l = new HistoryChangedListener(){

            @Override
            public void historyChanged(List<String> history) {
                Main.pref.put("osb.comment.history", StringUtils.listToString(history, "\u00a7\u00a7\u00a7"));
            }
        };
        String comment = TextInputDialog.showDialog((JComponent)Main.map, I18n.tr((String)"Really close?"), I18n.tr((String)"<html>Really mark this issue as ''done''?<br><br>You may add an optional comment:</html>"), OsbPlugin.loadIcon("icon_valid22.png"), history, l);
        if (comment != null) {
            if (comment.length() > 0) {
                comment = this.addMesgInfo(comment);
                this.commentAction.execute(CloseIssueAction.getSelectedNode(), comment);
            }
            this.closeAction.execute(CloseIssueAction.getSelectedNode());
        }
    }
}

