/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.osb.gui.historycombobox;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTextField;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.plugins.osb.gui.historycombobox.EventConsumingPlainDocument;
import org.openstreetmap.josm.plugins.osb.gui.historycombobox.JHistoryComboBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuggestingJHistoryComboBox
extends JHistoryComboBox
implements KeyListener {
    private EventConsumingPlainDocument doc = new EventConsumingPlainDocument();

    public SuggestingJHistoryComboBox(List<String> history) {
        super(history);
        this.getEditor().getEditorComponent().addKeyListener(this);
        ((JTextComponent)this.getEditor().getEditorComponent()).setDocument(this.doc);
        JTextField editor = (JTextField)this.getEditor().getEditorComponent();
        final AbstractDocument doc = (AbstractDocument)editor.getDocument();
        doc.setDocumentFilter(new DocumentFilter(){

            public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
                super.insertString(fb, offset, string, attr);
                if (doc.getLength() > 0) {
                    SuggestingJHistoryComboBox.this.suggest();
                }
            }

            public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
                super.replace(fb, offset, length, text, attrs);
                if (doc.getLength() > 0) {
                    SuggestingJHistoryComboBox.this.suggest();
                }
            }
        });
    }

    public SuggestingJHistoryComboBox() {
        this(new ArrayList<String>());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JTextField) {
            JTextField textField = (JTextField)e.getSource();
            if ("SUGGEST".equals(e.getActionCommand())) {
                textField.setSelectionStart(textField.getText().length());
                textField.setSelectionEnd(textField.getText().length());
                textField.setActionCommand("");
            } else {
                super.actionPerformed(e);
            }
        }
    }

    private void suggest() {
        JTextField textField = (JTextField)this.getEditor().getEditorComponent();
        String text = textField.getText();
        for (String suggestion : this.model) {
            if (!suggestion.startsWith(text)) continue;
            textField.setActionCommand("SUGGEST");
            this.doc.setConsumeEvents(true);
            textField.setText(suggestion);
            textField.setSelectionStart(text.length());
            textField.setSelectionEnd(textField.getText().length());
            this.doc.setConsumeEvents(false);
            break;
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 32 && e.isControlDown()) {
            this.suggest();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

