/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.jetty9;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.servlet.WireMockHttpServletMultipartAdapter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Collection;
import javax.servlet.ServletException;
import javax.servlet.http.Part;
import wiremock.com.google.common.base.Function;
import wiremock.com.google.common.collect.FluentIterable;
import wiremock.org.eclipse.jetty.util.MultiPartInputStreamParser;

public class MultipartParser {
    public static Collection<Request.Part> parse(byte[] body, String contentType) {
        MultiPartInputStreamParser parser = new MultiPartInputStreamParser(new ByteArrayInputStream(body), contentType, null, null);
        try {
            return FluentIterable.from(parser.getParts()).transform(new Function<Part, Request.Part>(){

                @Override
                public Request.Part apply(Part input) {
                    return WireMockHttpServletMultipartAdapter.from(input);
                }
            }).toList();
        }
        catch (IOException | ServletException e) {
            return Exceptions.throwUnchecked(e, Collection.class);
        }
    }
}

