/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.log;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import net.sourceforge.pmd.util.log.PmdLogFormatter;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.XmlLogger;
import org.apache.tools.ant.taskdefs.RecorderEntry;

public class AntLogHandler
extends Handler {
    private Project project;
    private static final Level DEFAULT_LEVEL = Level.WARNING;
    private static final Formatter FORMATTER = new PmdLogFormatter();
    private static final Level[] LOG_LEVELS = new Level[]{Level.SEVERE, Level.WARNING, Level.INFO, Level.CONFIG, Level.FINEST};

    public AntLogHandler(Project project) {
        this.project = project;
    }

    public Level getAntLogLevel() {
        for (BuildListener l : this.project.getBuildListeners()) {
            Field declaredField = null;
            try {
                if (l instanceof DefaultLogger) {
                    declaredField = DefaultLogger.class.getDeclaredField("msgOutputLevel");
                } else if (l instanceof XmlLogger) {
                    declaredField = XmlLogger.class.getDeclaredField("msgOutputLevel");
                } else if (l instanceof RecorderEntry) {
                    declaredField = RecorderEntry.class.getDeclaredField("loglevel");
                } else {
                    if (l.getClass().getName().equals("org.gradle.api.internal.project.ant.AntLoggingAdapter")) {
                        return this.determineGradleLogLevel(l);
                    }
                    try {
                        declaredField = l.getClass().getDeclaredField("logLevel");
                        if (declaredField.getType() != Integer.class && declaredField.getType() != Integer.TYPE) {
                            declaredField = null;
                            this.project.log("Unsupported build listener: " + l.getClass(), 4);
                        }
                    }
                    catch (NoSuchFieldException e) {
                        this.project.log("Unsupported build listener: " + l.getClass(), 4);
                    }
                }
                if (declaredField == null) continue;
                declaredField.setAccessible(true);
                return LOG_LEVELS[declaredField.getInt(l)];
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
            }
        }
        this.project.log("Could not determine ant log level, no supported build listeners found. Log level is set to " + DEFAULT_LEVEL, 1);
        return DEFAULT_LEVEL;
    }

    @Override
    public void publish(LogRecord logRecord) {
        int antLevel;
        Level level = logRecord.getLevel();
        if (level == Level.FINEST) {
            antLevel = 4;
        } else if (level == Level.FINE || level == Level.FINER || level == Level.CONFIG) {
            antLevel = 3;
        } else if (level == Level.INFO) {
            antLevel = 2;
        } else if (level == Level.WARNING) {
            antLevel = 1;
        } else if (level == Level.SEVERE) {
            antLevel = 0;
        } else {
            throw new IllegalStateException("Unknown logging level");
        }
        this.project.log(FORMATTER.format(logRecord), antLevel);
        if (logRecord.getThrown() != null) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
            logRecord.getThrown().printStackTrace(printWriter);
            this.project.log(stringWriter.toString(), antLevel);
        }
    }

    @Override
    public void close() throws SecurityException {
    }

    @Override
    public void flush() {
    }

    private Level determineGradleLogLevel(BuildListener l) {
        try {
            this.project.log("Detected gradle AntLoggingAdapter", 4);
            Field loggerField = l.getClass().getDeclaredField("logger");
            loggerField.setAccessible(true);
            Object logger = loggerField.get(l);
            Class<?> gradleLogLevel = l.getClass().getClassLoader().loadClass("org.gradle.api.logging.LogLevel");
            Method isLevelAtMostMethod = logger.getClass().getDeclaredMethod("isLevelAtMost", gradleLogLevel);
            isLevelAtMostMethod.setAccessible(true);
            ?[] logLevels = gradleLogLevel.getEnumConstants();
            Level[] mapping = new Level[]{Level.FINEST, Level.CONFIG, Level.INFO, Level.WARNING, Level.SEVERE, Level.SEVERE};
            for (int i = 0; i < Math.min(logLevels.length, mapping.length); ++i) {
                boolean enabled = (Boolean)isLevelAtMostMethod.invoke(logger, logLevels[i]);
                if (!enabled) continue;
                this.project.log("Current log level: " + logLevels[i] + " -> " + mapping[i], 4);
                return mapping[i];
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        this.project.log("Could not determine log level, falling back to default: " + DEFAULT_LEVEL, 1);
        return DEFAULT_LEVEL;
    }
}

