/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.datasource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.sourceforge.pmd.util.datasource.DataSource;

public class FileDataSource
implements DataSource {
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private final File file;

    public FileDataSource(File file) {
        this.file = file;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return Files.newInputStream(this.file.toPath(), new OpenOption[0]);
    }

    @Override
    public String getNiceFileName(boolean shortNames, String inputFileName) {
        return this.glomName(shortNames, inputFileName, this.file);
    }

    private String glomName(boolean shortNames, String inputFileName, File file) {
        if (shortNames) {
            if (inputFileName != null) {
                for (String prefix : inputFileName.split(",")) {
                    Path prefPath = Paths.get(prefix, new String[0]).toAbsolutePath();
                    String prefPathString = prefPath.toString();
                    String absoluteFilePath = file.getAbsolutePath();
                    if (!absoluteFilePath.startsWith(prefPathString)) continue;
                    if (prefPath.toFile().isDirectory()) {
                        return this.trimAnyPathSep(absoluteFilePath.substring(prefPathString.length()));
                    }
                    if (inputFileName.indexOf(FILE_SEPARATOR.charAt(0)) == -1) {
                        return inputFileName;
                    }
                    return this.trimAnyPathSep(absoluteFilePath.substring(prefPathString.lastIndexOf(FILE_SEPARATOR)));
                }
            } else {
                return file.getName();
            }
        }
        try {
            return file.getCanonicalFile().getAbsolutePath();
        }
        catch (Exception e) {
            return file.getAbsolutePath();
        }
    }

    private String trimAnyPathSep(String name) {
        return name.startsWith(FILE_SEPARATOR) ? name.substring(1) : name;
    }

    public String toString() {
        return FileDataSource.class.getSimpleName() + '[' + this.file.getPath() + ']';
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileDataSource other = (FileDataSource)obj;
        return !(this.file == null ? other.file != null : !this.file.equals(other.file));
    }
}

