/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;

public class ImportWrapper {
    private Node node;
    private String name;
    private String fullname;
    private boolean isStaticDemand;
    private Set<String> allDemands = new HashSet<String>();

    public ImportWrapper(String fullname, String name) {
        this(fullname, name, null);
    }

    public ImportWrapper(String fullname, String name, Node node) {
        this(fullname, name, node, false);
    }

    public ImportWrapper(String fullname, String name, Node node, Class<?> type, boolean isStaticDemand) {
        this(fullname, name, node, isStaticDemand);
        if (type != null) {
            for (Method method : type.getMethods()) {
                this.allDemands.add(method.getName());
            }
            for (AccessibleObject accessibleObject : type.getFields()) {
                this.allDemands.add(((Field)accessibleObject).getName());
            }
            for (AccessibleObject accessibleObject : type.getDeclaredFields()) {
                if (!Modifier.isStatic(((Field)accessibleObject).getModifiers())) continue;
                this.allDemands.add(((Field)accessibleObject).getName());
            }
            for (AccessibleObject accessibleObject : type.getDeclaredMethods()) {
                if (!Modifier.isStatic(((Method)accessibleObject).getModifiers())) continue;
                this.allDemands.add(((Method)accessibleObject).getName());
            }
        }
    }

    public ImportWrapper(String fullname, String name, Node node, boolean isStaticDemand) {
        this.fullname = fullname;
        this.name = name;
        this.node = node;
        this.isStaticDemand = isStaticDemand;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (other instanceof ImportWrapper) {
            ImportWrapper i = (ImportWrapper)other;
            if (this.name == null && i.getName() == null) {
                return i.getFullName().equals(this.fullname);
            }
            return i.getName().equals(this.name);
        }
        return false;
    }

    public boolean matches(ImportWrapper i) {
        if (this.isStaticDemand && this.allDemands.contains(i.fullname)) {
            return true;
        }
        if (this.name == null && i.getName() == null) {
            return i.getFullName().equals(this.fullname);
        }
        return i.getName().equals(this.name);
    }

    public int hashCode() {
        if (this.name == null) {
            return this.fullname.hashCode();
        }
        return this.name.hashCode();
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.fullname;
    }

    public Node getNode() {
        return this.node;
    }

    public boolean isStaticOnDemand() {
        return this.isStaticDemand;
    }

    public String toString() {
        return "Import[name=" + this.name + ",fullname=" + this.fullname + ",static*=" + this.isStaticDemand + ']';
    }
}

