/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd.token;

import net.sourceforge.pmd.cpd.token.TokenFilter;
import net.sourceforge.pmd.lang.TokenManager;
import net.sourceforge.pmd.lang.ast.GenericToken;

public class JavaCCTokenFilter
implements TokenFilter {
    private final TokenManager tokenManager;
    private boolean discardingSuppressing;

    public JavaCCTokenFilter(TokenManager tokenManager) {
        this.tokenManager = tokenManager;
    }

    @Override
    public final GenericToken getNextToken() {
        GenericToken currentToken = (GenericToken)this.tokenManager.getNextToken();
        while (!currentToken.getImage().isEmpty()) {
            this.analyzeToken(currentToken);
            this.processCPDSuppression(currentToken);
            if (!this.isDiscarding()) {
                return currentToken;
            }
            currentToken = (GenericToken)this.tokenManager.getNextToken();
        }
        return null;
    }

    private boolean isDiscarding() {
        return this.discardingSuppressing || this.isLanguageSpecificDiscarding();
    }

    private void processCPDSuppression(GenericToken currentToken) {
        for (GenericToken comment = currentToken.getPreviousComment(); comment != null; comment = comment.getPreviousComment()) {
            if (comment.getImage().contains("CPD-OFF")) {
                this.discardingSuppressing = true;
                break;
            }
            if (!comment.getImage().contains("CPD-ON")) continue;
            this.discardingSuppressing = false;
            break;
        }
    }

    protected boolean isLanguageSpecificDiscarding() {
        return false;
    }

    protected void analyzeToken(GenericToken currentToken) {
    }
}

