/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.util;

import nl.jqno.equalsverifier.Func;
import nl.jqno.equalsverifier.internal.prefabvalues.FactoryCache;
import nl.jqno.equalsverifier.internal.prefabvalues.factories.Factories;
import nl.jqno.equalsverifier.internal.prefabvalues.factories.PrefabValueFactory;
import nl.jqno.equalsverifier.internal.reflection.ObjectAccessor;
import nl.jqno.equalsverifier.internal.util.Validations;

public final class PrefabValuesApi {
    private PrefabValuesApi() {
    }

    public static <T> void addPrefabValues(FactoryCache factoryCache, Class<T> otherType, T red, T black) {
        Validations.validateRedAndBlackPrefabValues(otherType, red, black);
        if (red.getClass().isArray()) {
            factoryCache.put(otherType, Factories.values(red, black, red));
        } else {
            try {
                T redCopy = ObjectAccessor.of(red).copy();
                factoryCache.put(otherType, Factories.values(red, black, redCopy));
            }
            catch (RuntimeException ignored) {
                factoryCache.put(otherType, Factories.values(red, black, red));
            }
        }
    }

    public static <T> void addGenericPrefabValues(FactoryCache factoryCache, Class<T> otherType, Func.Func1<?, T> factory) {
        Validations.validateNotNull(factory, "factory is null.");
        PrefabValuesApi.addGenericPrefabValueFactory(factoryCache, otherType, Factories.simple(factory, null), 1);
    }

    public static <T> void addGenericPrefabValues(FactoryCache factoryCache, Class<T> otherType, Func.Func2<?, ?, T> factory) {
        Validations.validateNotNull(factory, "factory is null.");
        PrefabValuesApi.addGenericPrefabValueFactory(factoryCache, otherType, Factories.simple(factory, null), 2);
    }

    private static <T> void addGenericPrefabValueFactory(FactoryCache factoryCache, Class<T> otherType, PrefabValueFactory<T> factory, int arity) {
        Validations.validateGenericPrefabValues(otherType, factory, arity);
        factoryCache.put(otherType, factory);
    }
}

