/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Set;
import nl.jqno.equalsverifier.internal.exceptions.ReflectionException;
import nl.jqno.equalsverifier.internal.prefabvalues.PrefabValues;
import nl.jqno.equalsverifier.internal.prefabvalues.TypeTag;
import nl.jqno.equalsverifier.internal.reflection.FieldAccessor;
import nl.jqno.equalsverifier.internal.reflection.FieldIterable;
import nl.jqno.equalsverifier.internal.reflection.Instantiator;
import nl.jqno.equalsverifier.internal.reflection.ObjectAccessor;
import nl.jqno.equalsverifier.internal.reflection.annotations.AnnotationCache;
import nl.jqno.equalsverifier.internal.reflection.annotations.NonnullAnnotationVerifier;

public class ClassAccessor<T> {
    private final Class<T> type;
    private final PrefabValues prefabValues;

    ClassAccessor(Class<T> type, PrefabValues prefabValues) {
        this.type = type;
        this.prefabValues = prefabValues;
    }

    public static <T> ClassAccessor<T> of(Class<T> type, PrefabValues prefabValues) {
        return new ClassAccessor<T>(type, prefabValues);
    }

    public Class<T> getType() {
        return this.type;
    }

    public boolean declaresField(Field field) {
        try {
            this.type.getDeclaredField(field.getName());
            return true;
        }
        catch (NoSuchFieldException e) {
            return false;
        }
    }

    public boolean declaresEquals() {
        return this.declaresMethod("equals", Object.class);
    }

    public boolean declaresHashCode() {
        return this.declaresMethod("hashCode", new Class[0]);
    }

    private boolean declaresMethod(String name, Class<?> ... parameterTypes) {
        try {
            this.type.getDeclaredMethod(name, parameterTypes);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public boolean isEqualsAbstract() {
        return this.isMethodAbstract("equals", Object.class);
    }

    public boolean isHashCodeAbstract() {
        return this.isMethodAbstract("hashCode", new Class[0]);
    }

    private boolean isMethodAbstract(String name, Class<?> ... parameterTypes) {
        try {
            return Modifier.isAbstract(this.type.getMethod(name, parameterTypes).getModifiers());
        }
        catch (NoSuchMethodException e) {
            throw new ReflectionException("Should never occur (famous last words)");
        }
    }

    public boolean isEqualsInheritedFromObject() {
        ClassAccessor<T> i = this;
        while (i.getType() != Object.class) {
            if (i.declaresEquals() && !i.isEqualsAbstract()) {
                return false;
            }
            i = i.getSuperAccessor();
        }
        return true;
    }

    public ClassAccessor<? super T> getSuperAccessor() {
        return ClassAccessor.of(this.type.getSuperclass(), this.prefabValues);
    }

    public T getRedObject(TypeTag enclosingType) {
        return this.getRedAccessor(enclosingType).get();
    }

    public ObjectAccessor<T> getRedAccessor(TypeTag enclosingType) {
        ObjectAccessor<T> result = this.buildObjectAccessor();
        result.scramble(this.prefabValues, enclosingType);
        return result;
    }

    public T getBlackObject(TypeTag enclosingType) {
        return this.getBlackAccessor(enclosingType).get();
    }

    public ObjectAccessor<T> getBlackAccessor(TypeTag enclosingType) {
        ObjectAccessor<T> result = this.buildObjectAccessor();
        result.scramble(this.prefabValues, enclosingType);
        result.scramble(this.prefabValues, enclosingType);
        return result;
    }

    public ObjectAccessor<T> getDefaultValuesAccessor(TypeTag enclosingType, Set<String> nonnullFields, AnnotationCache annotationCache) {
        ObjectAccessor<T> result = this.buildObjectAccessor();
        for (Field field : FieldIterable.of(this.type)) {
            if (!NonnullAnnotationVerifier.fieldIsNonnull(field, annotationCache) && !nonnullFields.contains(field.getName())) continue;
            FieldAccessor accessor = result.fieldAccessorFor(field);
            accessor.changeField(this.prefabValues, enclosingType);
        }
        return result;
    }

    private ObjectAccessor<T> buildObjectAccessor() {
        T object = Instantiator.of(this.type).instantiate();
        return ObjectAccessor.of(object);
    }
}

