/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.prefabvalues.factoryproviders;

import com.google.common.base.Optional;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ArrayTable;
import com.google.common.collect.BiMap;
import com.google.common.collect.ConcurrentHashMultiset;
import com.google.common.collect.EnumBiMap;
import com.google.common.collect.EnumHashBiMap;
import com.google.common.collect.EnumMultiset;
import com.google.common.collect.EvictingQueue;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedMultiset;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MinMaxPriorityQueue;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.SortedMultiset;
import com.google.common.collect.SortedSetMultimap;
import com.google.common.collect.Table;
import com.google.common.collect.TreeBasedTable;
import com.google.common.collect.TreeMultimap;
import com.google.common.collect.TreeMultiset;
import com.google.common.collect.TreeRangeSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import nl.jqno.equalsverifier.internal.prefabvalues.FactoryCache;
import nl.jqno.equalsverifier.internal.prefabvalues.PrefabValues;
import nl.jqno.equalsverifier.internal.prefabvalues.Tuple;
import nl.jqno.equalsverifier.internal.prefabvalues.TypeTag;
import nl.jqno.equalsverifier.internal.prefabvalues.factories.AbstractGenericFactory;
import nl.jqno.equalsverifier.internal.prefabvalues.factories.EnumMapFactory;
import nl.jqno.equalsverifier.internal.prefabvalues.factories.EnumSetFactory;
import nl.jqno.equalsverifier.internal.prefabvalues.factories.Factories;
import nl.jqno.equalsverifier.internal.prefabvalues.factoryproviders.FactoryProvider;

public final class GuavaFactoryProvider
implements FactoryProvider {
    private static final Comparator<Object> OBJECT_COMPARATOR = Comparator.comparingInt(Object::hashCode);

    @Override
    public FactoryCache getFactoryCache() {
        FactoryCache cache = new FactoryCache();
        this.putMultisets(cache);
        this.putMultimaps(cache);
        this.putBiMaps(cache);
        this.putTables(cache);
        this.putRegularCollections(cache);
        this.putImmutableClasses(cache);
        this.putNewTypes(cache);
        return cache;
    }

    private void putMultisets(FactoryCache cache) {
        cache.put(Multiset.class, Factories.collection(HashMultiset::create));
        cache.put(SortedMultiset.class, Factories.collection(() -> TreeMultiset.create(OBJECT_COMPARATOR)));
        cache.put(HashMultiset.class, Factories.collection(HashMultiset::create));
        cache.put(TreeMultiset.class, Factories.collection(() -> TreeMultiset.create(OBJECT_COMPARATOR)));
        cache.put(LinkedHashMultiset.class, Factories.collection(LinkedHashMultiset::create));
        cache.put(ConcurrentHashMultiset.class, Factories.collection(ConcurrentHashMultiset::create));
        cache.put(EnumMultiset.class, new EnumSetFactory<EnumMultiset>(EnumMultiset::create));
        cache.put(ImmutableMultiset.class, Factories.copy(Set.class, ImmutableMultiset::copyOf));
        cache.put(ImmutableSortedMultiset.class, Factories.copy(SortedMultiset.class, ImmutableSortedMultiset::copyOfSorted));
    }

    private void putMultimaps(FactoryCache cache) {
        cache.put(Multimap.class, this.multimap(ArrayListMultimap::create));
        cache.put(ListMultimap.class, this.multimap(ArrayListMultimap::create));
        cache.put(SetMultimap.class, this.multimap(HashMultimap::create));
        cache.put(SortedSetMultimap.class, this.multimap(() -> TreeMultimap.create(OBJECT_COMPARATOR, OBJECT_COMPARATOR)));
        cache.put(ArrayListMultimap.class, this.multimap(ArrayListMultimap::create));
        cache.put(HashMultimap.class, this.multimap(HashMultimap::create));
        cache.put(LinkedListMultimap.class, this.multimap(LinkedListMultimap::create));
        cache.put(LinkedHashMultimap.class, this.multimap(LinkedHashMultimap::create));
        cache.put(TreeMultimap.class, this.multimap(() -> TreeMultimap.create(OBJECT_COMPARATOR, OBJECT_COMPARATOR)));
        cache.put(ImmutableListMultimap.class, Factories.copy(Multimap.class, ImmutableListMultimap::copyOf));
        cache.put(ImmutableSetMultimap.class, Factories.copy(Multimap.class, ImmutableSetMultimap::copyOf));
        cache.put(ImmutableMultimap.class, Factories.copy(Multimap.class, ImmutableListMultimap::copyOf));
    }

    private void putBiMaps(FactoryCache cache) {
        cache.put(BiMap.class, Factories.map(HashBiMap::create));
        cache.put(HashBiMap.class, Factories.map(HashBiMap::create));
        cache.put(EnumHashBiMap.class, Factories.copy(EnumMap.class, EnumHashBiMap::create));
        cache.put(ImmutableBiMap.class, Factories.copy(Map.class, ImmutableBiMap::copyOf));
        cache.put(EnumBiMap.class, new EnumMapFactory<EnumBiMap>(EnumBiMap::create));
    }

    private void putTables(FactoryCache cache) {
        cache.put(Table.class, this.table(HashBasedTable::create));
        cache.put(HashBasedTable.class, this.table(HashBasedTable::create));
        cache.put(TreeBasedTable.class, this.table(() -> TreeBasedTable.create(OBJECT_COMPARATOR, OBJECT_COMPARATOR)));
        cache.put(ArrayTable.class, Factories.copy(Table.class, ArrayTable::create));
        cache.put(ImmutableTable.class, Factories.copy(Table.class, ImmutableTable::copyOf));
    }

    private void putRegularCollections(FactoryCache cache) {
        cache.put(EvictingQueue.class, Factories.collection(() -> EvictingQueue.create((int)10)));
        cache.put(MinMaxPriorityQueue.class, Factories.collection(() -> MinMaxPriorityQueue.orderedBy(OBJECT_COMPARATOR).create()));
        cache.put(ImmutableRangeSet.class, Factories.copy(Range.class, ImmutableRangeSet::of));
        cache.put(TreeRangeSet.class, Factories.copy(ImmutableRangeSet.class, TreeRangeSet::create));
        cache.put(RangeSet.class, Factories.copy(ImmutableRangeSet.class, TreeRangeSet::create));
    }

    private void putImmutableClasses(FactoryCache cache) {
        cache.put(ImmutableCollection.class, Factories.copy(Collection.class, ImmutableList::copyOf));
        cache.put(ImmutableList.class, Factories.copy(Collection.class, ImmutableList::copyOf));
        cache.put(ImmutableMap.class, Factories.copy(Map.class, ImmutableMap::copyOf));
        cache.put(ImmutableSet.class, Factories.copy(Collection.class, ImmutableSet::copyOf));
        cache.put(ImmutableSortedMap.class, Factories.copy(Map.class, ImmutableSortedMap::copyOf));
        cache.put(ImmutableSortedSet.class, Factories.copy(Set.class, ImmutableSortedSet::copyOf));
    }

    private void putNewTypes(FactoryCache cache) {
        cache.put(Range.class, Factories.simple(Range::atLeast, Range::all));
        cache.put(Optional.class, Factories.simple(Optional::of, Optional::absent));
    }

    private <K, V, T extends Multimap<K, V>> MultimapFactory<K, V, T> multimap(Supplier<T> factory) {
        return new MultimapFactory(factory);
    }

    private <C, R, V, T extends Table<C, R, V>> TableFactory<C, R, V, T> table(Supplier<T> factory) {
        return new TableFactory(factory);
    }

    private static final class TableFactory<C, R, V, T extends Table<C, R, V>>
    extends AbstractGenericFactory<T> {
        private final Supplier<T> factory;

        private TableFactory(Supplier<T> factory) {
            this.factory = factory;
        }

        @Override
        public Tuple<T> createValues(TypeTag tag, PrefabValues prefabValues, LinkedHashSet<TypeTag> typeStack) {
            LinkedHashSet<TypeTag> clone = this.cloneWith(typeStack, tag);
            TypeTag columnTag = this.determineAndCacheActualTypeTag(0, tag, prefabValues, clone);
            TypeTag rowTag = this.determineAndCacheActualTypeTag(1, tag, prefabValues, clone);
            TypeTag valueTag = this.determineAndCacheActualTypeTag(2, tag, prefabValues, clone);
            Table red = (Table)this.factory.get();
            Table black = (Table)this.factory.get();
            Table redCopy = (Table)this.factory.get();
            red.put(prefabValues.giveRed(columnTag), prefabValues.giveRed(rowTag), prefabValues.giveBlack(valueTag));
            black.put(prefabValues.giveBlack(columnTag), prefabValues.giveBlack(rowTag), prefabValues.giveBlack(valueTag));
            redCopy.put(prefabValues.giveRed(columnTag), prefabValues.giveRed(rowTag), prefabValues.giveBlack(valueTag));
            return Tuple.of(red, black, redCopy);
        }
    }

    private static final class MultimapFactory<K, V, T extends Multimap<K, V>>
    extends AbstractGenericFactory<T> {
        private final Supplier<T> factory;

        private MultimapFactory(Supplier<T> factory) {
            this.factory = factory;
        }

        @Override
        public Tuple<T> createValues(TypeTag tag, PrefabValues prefabValues, LinkedHashSet<TypeTag> typeStack) {
            LinkedHashSet<TypeTag> clone = this.cloneWith(typeStack, tag);
            TypeTag keyTag = this.determineAndCacheActualTypeTag(0, tag, prefabValues, clone);
            TypeTag valueTag = this.determineAndCacheActualTypeTag(1, tag, prefabValues, clone);
            Multimap red = (Multimap)this.factory.get();
            Multimap black = (Multimap)this.factory.get();
            Multimap redCopy = (Multimap)this.factory.get();
            red.put(prefabValues.giveRed(keyTag), prefabValues.giveBlack(valueTag));
            black.put(prefabValues.giveBlack(keyTag), prefabValues.giveBlack(valueTag));
            redCopy.put(prefabValues.giveRed(keyTag), prefabValues.giveBlack(valueTag));
            return Tuple.of(red, black, redCopy);
        }
    }
}

