/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.prefabvalues;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import nl.jqno.equalsverifier.internal.prefabvalues.factories.PrefabValueFactory;

public class FactoryCache
implements Iterable<Map.Entry<String, PrefabValueFactory<?>>> {
    private final Map<String, PrefabValueFactory<?>> cache = new HashMap();

    public <T> void put(Class<?> type, PrefabValueFactory<T> factory) {
        if (type != null) {
            this.cache.put(type.getName(), factory);
        }
    }

    public <T> void put(String typeName, PrefabValueFactory<T> factory) {
        if (typeName != null) {
            this.cache.put(typeName, factory);
        }
    }

    public <T> PrefabValueFactory<T> get(Class<T> type) {
        if (type == null) {
            return null;
        }
        return this.cache.get(type.getName());
    }

    public boolean contains(Class<?> type) {
        return this.cache.containsKey(type.getName());
    }

    public FactoryCache merge(FactoryCache other) {
        FactoryCache result = new FactoryCache();
        this.copy(result, this);
        this.copy(result, other);
        return result;
    }

    private void copy(FactoryCache to, FactoryCache from) {
        for (Map.Entry<String, PrefabValueFactory<?>> entry : from) {
            to.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Iterator<Map.Entry<String, PrefabValueFactory<?>>> iterator() {
        return this.cache.entrySet().iterator();
    }
}

