/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.checkers.fieldchecks;

import nl.jqno.equalsverifier.internal.checkers.fieldchecks.FieldCheck;
import nl.jqno.equalsverifier.internal.reflection.FieldAccessor;
import nl.jqno.equalsverifier.internal.util.Assert;
import nl.jqno.equalsverifier.internal.util.Formatter;

public class FloatAndDoubleFieldCheck
implements FieldCheck {
    @Override
    public void execute(FieldAccessor referenceAccessor, FieldAccessor changedAccessor) {
        Class<?> type = referenceAccessor.getFieldType();
        if (this.isFloat(type)) {
            referenceAccessor.set(Float.valueOf(Float.NaN));
            changedAccessor.set(Float.valueOf(Float.NaN));
            Assert.assertEquals(Formatter.of("Float: equals doesn't use Float.compare for field %%.", referenceAccessor.getFieldName()), referenceAccessor.getObject(), changedAccessor.getObject());
        }
        if (this.isDouble(type)) {
            referenceAccessor.set(Double.NaN);
            changedAccessor.set(Double.NaN);
            Assert.assertEquals(Formatter.of("Double: equals doesn't use Double.compare for field %%.", referenceAccessor.getFieldName()), referenceAccessor.getObject(), changedAccessor.getObject());
        }
    }

    private boolean isFloat(Class<?> type) {
        return type == Float.TYPE || type == Float.class;
    }

    private boolean isDouble(Class<?> type) {
        return type == Double.TYPE || type == Double.class;
    }
}

