/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.checkers;

import java.util.function.Predicate;
import nl.jqno.equalsverifier.Warning;
import nl.jqno.equalsverifier.internal.checkers.Checker;
import nl.jqno.equalsverifier.internal.checkers.FieldInspector;
import nl.jqno.equalsverifier.internal.checkers.fieldchecks.ArrayFieldCheck;
import nl.jqno.equalsverifier.internal.checkers.fieldchecks.FloatAndDoubleFieldCheck;
import nl.jqno.equalsverifier.internal.checkers.fieldchecks.MutableStateFieldCheck;
import nl.jqno.equalsverifier.internal.checkers.fieldchecks.ReflexivityFieldCheck;
import nl.jqno.equalsverifier.internal.checkers.fieldchecks.SignificantFieldCheck;
import nl.jqno.equalsverifier.internal.checkers.fieldchecks.SymmetryFieldCheck;
import nl.jqno.equalsverifier.internal.checkers.fieldchecks.TransientFieldsCheck;
import nl.jqno.equalsverifier.internal.checkers.fieldchecks.TransitivityFieldCheck;
import nl.jqno.equalsverifier.internal.prefabvalues.PrefabValues;
import nl.jqno.equalsverifier.internal.prefabvalues.TypeTag;
import nl.jqno.equalsverifier.internal.reflection.ClassAccessor;
import nl.jqno.equalsverifier.internal.reflection.FieldAccessor;
import nl.jqno.equalsverifier.internal.reflection.annotations.AnnotationCache;
import nl.jqno.equalsverifier.internal.reflection.annotations.SupportedAnnotations;
import nl.jqno.equalsverifier.internal.util.Configuration;

public class FieldsChecker<T>
implements Checker {
    private final Configuration<T> config;
    private final ArrayFieldCheck<T> arrayFieldCheck;
    private final FloatAndDoubleFieldCheck floatAndDoubleFieldCheck;
    private final MutableStateFieldCheck mutableStateFieldCheck;
    private final ReflexivityFieldCheck<T> reflexivityFieldCheck;
    private final SignificantFieldCheck<T> significantFieldCheck;
    private final SignificantFieldCheck<T> skippingSignificantFieldCheck;
    private final SymmetryFieldCheck symmetryFieldCheck;
    private final TransientFieldsCheck<T> transientFieldsCheck;
    private final TransitivityFieldCheck transitivityFieldCheck;

    public FieldsChecker(Configuration<T> config) {
        this.config = config;
        PrefabValues prefabValues = config.getPrefabValues();
        TypeTag typeTag = config.getTypeTag();
        Predicate<FieldAccessor> isCachedHashCodeField = a -> a.getFieldName().equals(config.getCachedHashCodeInitializer().getCachedHashCodeFieldName());
        this.arrayFieldCheck = new ArrayFieldCheck<T>(config.getCachedHashCodeInitializer());
        this.floatAndDoubleFieldCheck = new FloatAndDoubleFieldCheck();
        this.mutableStateFieldCheck = new MutableStateFieldCheck(prefabValues, typeTag, isCachedHashCodeField);
        this.reflexivityFieldCheck = new ReflexivityFieldCheck<T>(config);
        this.significantFieldCheck = new SignificantFieldCheck<T>(config, isCachedHashCodeField, false);
        this.skippingSignificantFieldCheck = new SignificantFieldCheck<T>(config, isCachedHashCodeField, true);
        this.symmetryFieldCheck = new SymmetryFieldCheck(prefabValues, typeTag);
        this.transientFieldsCheck = new TransientFieldsCheck<T>(config);
        this.transitivityFieldCheck = new TransitivityFieldCheck(prefabValues, typeTag);
    }

    @Override
    public void check() {
        ClassAccessor<T> classAccessor = this.config.getClassAccessor();
        FieldInspector<T> inspector = new FieldInspector<T>(classAccessor, this.config.getTypeTag());
        if (!classAccessor.isEqualsInheritedFromObject()) {
            inspector.check(this.arrayFieldCheck);
            inspector.check(this.floatAndDoubleFieldCheck);
            inspector.check(this.reflexivityFieldCheck);
        }
        if (!this.ignoreMutability(this.config.getType())) {
            inspector.check(this.mutableStateFieldCheck);
        }
        if (!this.config.getWarningsToSuppress().contains((Object)Warning.TRANSIENT_FIELDS)) {
            inspector.check(this.transientFieldsCheck);
        }
        inspector.check(this.significantFieldCheck);
        inspector.check(this.symmetryFieldCheck);
        inspector.check(this.transitivityFieldCheck);
        if (!this.config.getWarningsToSuppress().contains((Object)Warning.NULL_FIELDS)) {
            inspector.checkWithNull(this.config.getNonnullFields(), this.config.getAnnotationCache(), this.skippingSignificantFieldCheck);
        }
    }

    private boolean ignoreMutability(Class<?> type) {
        AnnotationCache cache = this.config.getAnnotationCache();
        return this.config.getWarningsToSuppress().contains((Object)Warning.NONFINAL_FIELDS) || cache.hasClassAnnotation(type, SupportedAnnotations.IMMUTABLE) || cache.hasClassAnnotation(type, SupportedAnnotations.ENTITY);
    }
}

