/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier;

import java.util.List;
import nl.jqno.equalsverifier.EqualsVerifierApi;
import nl.jqno.equalsverifier.Warning;
import nl.jqno.equalsverifier.internal.util.ListBuilders;
import nl.jqno.equalsverifier.internal.util.Validations;

public class RelaxedEqualsVerifierApi<T> {
    private final Class<T> type;
    private final List<T> equalExamples;

    RelaxedEqualsVerifierApi(Class<T> type, List<T> examples) {
        this.type = type;
        this.equalExamples = examples;
    }

    public EqualsVerifierApi<T> andUnequalExample(T example) {
        return this.andUnequalExamples(example, new Object[0]);
    }

    @SafeVarargs
    public final EqualsVerifierApi<T> andUnequalExamples(T first, T ... more) {
        List<T> unequalExamples = ListBuilders.buildListOfAtLeastOne(first, more);
        Validations.validateUnequalExamples(unequalExamples, this.equalExamples);
        return new EqualsVerifierApi<T>(this.type, this.equalExamples, unequalExamples).suppress(Warning.ALL_FIELDS_SHOULD_BE_USED);
    }
}

