/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations;

import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.expectations.invocation.ExpectedInvocation;

final class EquivalentInstances {
    @Nonnull
    final Map<Object, Object> instanceMap = new IdentityHashMap<Object, Object>();
    @Nonnull
    final Map<Object, Object> replacementMap = new IdentityHashMap<Object, Object>();

    EquivalentInstances() {
    }

    void registerReplacementInstanceIfApplicable(@Nullable Object mock, @Nonnull ExpectedInvocation invocation) {
        Object replacementInstance = invocation.replacementInstance;
        if (replacementInstance != null && replacementInstance != invocation.instance) {
            this.replacementMap.put(mock, replacementInstance);
        }
    }

    boolean isEquivalentInstance(@Nonnull Object invocationInstance, @Nonnull Object invokedInstance) {
        return invocationInstance == invokedInstance || invocationInstance == this.replacementMap.get(invokedInstance) || invocationInstance == this.instanceMap.get(invokedInstance) || invokedInstance == this.instanceMap.get(invocationInstance);
    }

    boolean areNonEquivalentInstances(@Nonnull Object invocationInstance, @Nonnull Object invokedInstance) {
        boolean recordedInstanceMatchingAnyInstance = !this.isMatchingInstance(invocationInstance);
        boolean invokedInstanceMatchingSpecificInstance = this.isMatchingInstance(invokedInstance);
        return recordedInstanceMatchingAnyInstance && invokedInstanceMatchingSpecificInstance;
    }

    private boolean isMatchingInstance(@Nonnull Object instance) {
        return this.instanceMap.containsKey(instance) || this.instanceMap.containsValue(instance) || this.replacementMap.containsKey(instance) || this.replacementMap.containsValue(instance);
    }

    boolean areMatchingInstances(boolean matchInstance, @Nonnull Object mock1, @Nonnull Object mock2) {
        if (matchInstance) {
            return this.isEquivalentInstance(mock1, mock2);
        }
        return !this.areInDifferentEquivalenceSets(mock1, mock2);
    }

    private boolean areInDifferentEquivalenceSets(@Nonnull Object mock1, @Nonnull Object mock2) {
        if (mock1 == mock2 || this.instanceMap.isEmpty()) {
            return false;
        }
        Object mock1Equivalent = this.instanceMap.get(mock1);
        Object mock2Equivalent = this.instanceMap.get(mock2);
        if (mock1Equivalent == mock2 || mock2Equivalent == mock1) {
            return false;
        }
        if (mock1Equivalent != null && mock2Equivalent != null) {
            return true;
        }
        return this.instanceMapHasMocksInSeparateEntries(mock1, mock2);
    }

    private boolean instanceMapHasMocksInSeparateEntries(@Nonnull Object mock1, @Nonnull Object mock2) {
        boolean found1 = false;
        boolean found2 = false;
        for (Map.Entry<Object, Object> entry : this.instanceMap.entrySet()) {
            if (!found1 && EquivalentInstances.isInMapEntry(entry, mock1)) {
                found1 = true;
            }
            if (!found2 && EquivalentInstances.isInMapEntry(entry, mock2)) {
                found2 = true;
            }
            if (!found1 || !found2) continue;
            return true;
        }
        return false;
    }

    private static boolean isInMapEntry(@Nonnull Map.Entry<Object, Object> mapEntry, @Nonnull Object mock) {
        return mapEntry.getKey() == mock || mapEntry.getValue() == mock;
    }

    @Nullable
    Object getReplacementInstanceForMethodInvocation(@Nonnull Object invokedInstance, @Nonnull String methodNameAndDesc) {
        return methodNameAndDesc.charAt(0) == '<' ? null : this.replacementMap.get(invokedInstance);
    }

    boolean isReplacementInstance(@Nonnull Object invokedInstance, @Nonnull String methodNameAndDesc) {
        return methodNameAndDesc.charAt(0) != '<' && (this.replacementMap.containsKey(invokedInstance) || this.replacementMap.containsValue(invokedInstance));
    }
}

