/*
 * Decompiled with CFR 0.152.
 */
package mockit.asm.jvmConstants;

public final class Access {
    public static final int PUBLIC = 1;
    public static final int PRIVATE = 2;
    public static final int PROTECTED = 4;
    public static final int STATIC = 8;
    public static final int FINAL = 16;
    public static final int SUPER = 32;
    public static final int BRIDGE = 64;
    public static final int VARARGS = 128;
    public static final int NATIVE = 256;
    public static final int INTERFACE = 512;
    public static final int ABSTRACT = 1024;
    public static final int SYNTHETIC = 4096;
    public static final int ANNOTATION = 8192;
    public static final int ENUM = 16384;
    private static final int DEPRECATED = 131072;
    public static final int CONSTRUCTOR = 524288;
    private static final int SYNTHETIC_ATTRIBUTE = 262144;
    private static final int TO_SYNTHETIC = 64;

    private Access() {
    }

    public static boolean isDeprecated(int access) {
        return (access & 0x20000) != 0;
    }

    public static boolean isSynthetic(int access, int classVersion) {
        return (access & 0x1000) != 0 && ((access & 0x40000) != 0 || classVersion < 49);
    }

    public static boolean isConstructor(int access) {
        return (access & 0x80000) != 0;
    }

    public static int computeFlag(int access, int baseMask) {
        int mask = baseMask | 0x20000 | 0x40000 | (access & 0x40000) / 64;
        return access & ~mask;
    }

    public static int asDeprecated(int access) {
        return access | 0x20000;
    }

    public static int asSynthetic(int access) {
        return access | 0x1000 | 0x40000;
    }
}

