/*
 * Decompiled with CFR 0.152.
 */
package mockit.asm.classes;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.asm.AnnotatedReader;
import mockit.asm.classes.ClassInfo;
import mockit.asm.classes.ClassVisitor;
import mockit.asm.fields.FieldReader;
import mockit.asm.methods.MethodReader;

public final class ClassReader
extends AnnotatedReader {
    @Nonnegative
    final int header;
    @Nonnegative
    private final int version;
    @Nonnull
    private final ClassInfo classInfo;
    private ClassVisitor cv;
    @Nonnegative
    public int flags;
    @Nonnegative
    private int innerClassesCodeIndex;
    @Nonnegative
    private int attributesCodeIndex;
    @Nullable
    int[] bootstrapMethods;

    public ClassReader(@Nonnull byte[] code) {
        super(code);
        this.header = this.codeIndex;
        this.version = this.readShort(6);
        this.access = this.readUnsignedShort();
        this.classInfo = new ClassInfo();
        this.codeIndex += 2;
        this.classInfo.superName = this.readClass();
    }

    public int getVersion() {
        return this.version;
    }

    public int getAccess() {
        return this.access;
    }

    @Nonnull
    public String getSuperName() {
        assert (this.classInfo.superName != null);
        return this.classInfo.superName;
    }

    @Nonnull
    public byte[] getBytecode() {
        return this.code;
    }

    public void accept(ClassVisitor visitor) {
        this.accept(visitor, 0);
    }

    public void accept(@Nonnull ClassVisitor visitor, @Nonnegative int optionFlags) {
        this.cv = visitor;
        this.flags = optionFlags;
        this.codeIndex = this.header + 2;
        String classDesc = this.readNonnullClass();
        this.codeIndex += 2;
        this.readInterfaces();
        this.readClassAttributes();
        visitor.visit(this.version, this.access, classDesc, this.classInfo);
        this.readAnnotations(visitor);
        this.readInnerClasses();
        this.readFieldsAndMethods();
        visitor.visitEnd();
    }

    private void readInterfaces() {
        int interfaceCount = this.readUnsignedShort();
        if (interfaceCount > 0) {
            String[] interfaces = new String[interfaceCount];
            for (int i = 0; i < interfaceCount; ++i) {
                interfaces[i] = this.readNonnullClass();
            }
            this.classInfo.interfaces = interfaces;
        }
    }

    private void readClassAttributes() {
        this.innerClassesCodeIndex = 0;
        this.codeIndex = this.getAttributesStartIndex();
        this.readAttributes();
        this.classInfo.signature = this.signature;
    }

    @Override
    @Nullable
    protected Boolean readAttribute(@Nonnull String attributeName) {
        if ("SourceFile".equals(attributeName)) {
            this.classInfo.sourceFileName = this.readNonnullUTF8();
            return true;
        }
        if ("EnclosingMethod".equals(attributeName)) {
            return false;
        }
        if ("NestHost".equals(attributeName)) {
            this.classInfo.hostClassName = this.readNonnullClass();
            return true;
        }
        if ("NestMembers".equals(attributeName)) {
            this.readNestMembers();
            return true;
        }
        if ("BootstrapMethods".equals(attributeName)) {
            this.readBootstrapMethods();
            return true;
        }
        if ("InnerClasses".equals(attributeName)) {
            this.innerClassesCodeIndex = this.codeIndex;
            return false;
        }
        return null;
    }

    private void readNestMembers() {
        int numberOfClasses = this.readUnsignedShort();
        String[] nestMembers = new String[numberOfClasses];
        for (int i = 0; i < numberOfClasses; ++i) {
            nestMembers[i] = this.readNonnullClass();
        }
        this.classInfo.nestMembers = nestMembers;
    }

    private void readBootstrapMethods() {
        int bsmCount = this.readUnsignedShort();
        this.bootstrapMethods = new int[bsmCount];
        for (int i = 0; i < bsmCount; ++i) {
            this.bootstrapMethods[i] = this.codeIndex;
            this.codeIndex += 2;
            int codeOffset = this.readUnsignedShort();
            this.codeIndex += codeOffset << 1;
        }
    }

    private void readInnerClasses() {
        int startIndex = this.innerClassesCodeIndex;
        if (startIndex != 0) {
            this.codeIndex = startIndex;
            for (int innerClassCount = this.readUnsignedShort(); innerClassCount > 0; --innerClassCount) {
                String innerName = this.readNonnullClass();
                String outerName = this.readClass();
                String simpleInnerName = this.readUTF8();
                int innerAccess = this.readUnsignedShort();
                this.cv.visitInnerClass(innerName, outerName, simpleInnerName, innerAccess);
            }
        }
    }

    private void readFieldsAndMethods() {
        this.codeIndex = this.getCodeIndexAfterInterfaces(this.classInfo.interfaces.length);
        FieldReader fieldReader = new FieldReader(this, this.cv);
        this.codeIndex = fieldReader.readFields();
        MethodReader methodReader = new MethodReader(this, this.cv);
        this.codeIndex = methodReader.readMethods();
    }

    @Nonnegative
    private int getCodeIndexAfterInterfaces(@Nonnegative int interfaceCount) {
        return this.header + 8 + 2 * interfaceCount;
    }

    @Nonnegative
    private int getAttributesStartIndex() {
        if (this.attributesCodeIndex == 0) {
            this.skipHeader();
            this.skipClassMembers();
            this.skipClassMembers();
            this.attributesCodeIndex = this.codeIndex;
        }
        return this.attributesCodeIndex;
    }

    private void skipHeader() {
        int interfaceCount = this.readUnsignedShort(this.header + 6);
        this.codeIndex = this.getCodeIndexAfterInterfaces(interfaceCount);
    }

    private void skipClassMembers() {
        for (int memberCount = this.readUnsignedShort(); memberCount > 0; --memberCount) {
            this.codeIndex += 6;
            this.skipMemberAttributes();
        }
    }

    private void skipMemberAttributes() {
        for (int attributeCount = this.readUnsignedShort(); attributeCount > 0; --attributeCount) {
            this.codeIndex += 2;
            int codeOffsetToNextAttribute = this.readInt();
            this.codeIndex += codeOffsetToNextAttribute;
        }
    }

    boolean positionAtBootstrapMethodsAttribute() {
        this.codeIndex = this.getAttributesStartIndex();
        for (int attributeCount = this.readUnsignedShort(); attributeCount > 0; --attributeCount) {
            String attrName = this.readNonnullUTF8();
            if ("BootstrapMethods".equals(attrName)) {
                return true;
            }
            int codeOffsetToNextAttribute = this.readInt();
            this.codeIndex += codeOffsetToNextAttribute;
        }
        return false;
    }

    @Nonnegative
    public int getBSMCodeIndex(@Nonnegative int bsmStartIndex) {
        assert (this.bootstrapMethods != null);
        return this.bootstrapMethods[bsmStartIndex];
    }

    public static interface Flags {
        public static final int SKIP_CODE = 1;
        public static final int SKIP_DEBUG = 2;
    }
}

