/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.fxdesigner.util.controls;

import java.util.Map;
import javafx.scene.control.TreeItem;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.symboltable.Scope;
import net.sourceforge.pmd.lang.symboltable.ScopedNode;

public final class ScopeHierarchyTreeItem
extends TreeItem<Object> {
    private ScopeHierarchyTreeItem(Object scopeOrDecl) {
        super(scopeOrDecl);
        this.setExpanded(true);
    }

    public static ScopeHierarchyTreeItem buildAscendantHierarchy(Node node) {
        ScopeHierarchyTreeItem item = ScopeHierarchyTreeItem.buildAscendantHierarchyHelper(ScopeHierarchyTreeItem.getScope(node));
        if (item == null) {
            return null;
        }
        while (item.getParent() != null) {
            item = (ScopeHierarchyTreeItem)item.getParent();
        }
        return item;
    }

    private static ScopeHierarchyTreeItem buildAscendantHierarchyHelper(Scope scope) {
        if (scope == null) {
            return null;
        }
        ScopeHierarchyTreeItem scopeTreeNode = new ScopeHierarchyTreeItem(scope);
        for (Map.Entry entry : scope.getDeclarations().entrySet()) {
            ScopeHierarchyTreeItem nameDeclaration = new ScopeHierarchyTreeItem(entry.getKey());
            scopeTreeNode.getChildren().add((Object)nameDeclaration);
        }
        ScopeHierarchyTreeItem parent = ScopeHierarchyTreeItem.buildAscendantHierarchyHelper(scope.getParent());
        if (parent != null) {
            parent.getChildren().add((Object)scopeTreeNode);
        }
        return scopeTreeNode;
    }

    private static Scope getScope(Node node) {
        if (node instanceof ScopedNode) {
            return ((ScopedNode)node).getScope();
        }
        return null;
    }
}

