/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.fxdesigner.util.codearea.syntaxhighlighting;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum HighlightClasses {
    COMMENT("comment"),
    MULTIL_COMMENT("multi-line-comment", "comment"),
    SINGLEL_COMMENT("single-line-comment", "comment"),
    PUNCTUATION("punctuation"),
    PAREN("paren", "punctuation"),
    BRACE("brace", "punctuation"),
    BRACKET("bracket", "punctuation"),
    SEMICOLON("semicolon", "punctuation"),
    LITERAL("literal"),
    BOOLEAN("boolean", "literal"),
    STRING("string", "literal"),
    URI("uri", "string", "literal"),
    CHAR("char", "literal"),
    NULL("null", "literal"),
    NUMBER("number", "literal"),
    KEYWORD("keyword"),
    ANNOTATION("annotation"),
    CLASS_IDENTIFIER("class-identifier"),
    XPATH_ATTRIBUTE("attribute", "xpath"),
    XPATH_AXIS("axis", "xpath"),
    XPATH_FUNCTION("function", "xpath"),
    XPATH_PATH("path", "xpath", "punctuation"),
    XPATH_KIND_TEST("kind-test", "function", "xpath"),
    XML_CDATA_TAG("cdata-tag", "xml"),
    XML_CDATA_CONTENT("cdata-content", "xml"),
    XML_PROLOG("xml-prolog", "xml"),
    XML_LT_GT("lt-gt", "xml"),
    XML_TAG_NAME("tag-name", "xml"),
    XML_ATTRIBUTE_NAME("attribute-name", "xml");

    public final List<String> css;

    private HighlightClasses(String ... classes) {
        this.css = Collections.unmodifiableList(Arrays.asList(classes));
    }

    private static final class Constants {
        static final String LITERAL = "literal";
        static final String COMMENT = "comment";
        static final String PUNCTUATION = "punctuation";
        static final String XML = "xml";
        static final String XPATH = "xpath";

        private Constants() {
        }
    }
}

