/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.fxdesigner.util.codearea;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.sourceforge.pmd.util.fxdesigner.util.codearea.UniformStyleCollection;

class StyleLayer {
    private final Map<Set<String>, UniformStyleCollection> styleToCollection = new HashMap<Set<String>, UniformStyleCollection>();

    StyleLayer() {
    }

    public void clearStyles() {
        this.styleToCollection.clear();
    }

    public Collection<UniformStyleCollection> getCollections() {
        return this.styleToCollection.values();
    }

    public void styleNodes(UniformStyleCollection updates) {
        this.styleNodes(false, updates);
    }

    public void styleNodes(boolean reset, UniformStyleCollection updates) {
        if (reset) {
            this.clearStyles();
        }
        UniformStyleCollection newValue = Optional.ofNullable(this.styleToCollection.get(updates.getStyle())).map(updates::merge).orElse(updates);
        this.styleToCollection.put(updates.getStyle(), newValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StyleLayer that = (StyleLayer)o;
        return Objects.equals(this.styleToCollection, that.styleToCollection);
    }

    public int hashCode() {
        return Objects.hash(this.styleToCollection);
    }
}

