/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.fxdesigner.util.codearea;

import java.util.Collection;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.util.fxdesigner.util.TextAwareNodeWrapper;
import net.sourceforge.pmd.util.fxdesigner.util.codearea.SyntaxHighlightingCodeArea;
import org.fxmisc.richtext.model.Paragraph;
import org.fxmisc.richtext.model.StyledDocument;

class NodeStyleSpan {
    private static final Pattern TAB_INDENT = Pattern.compile("^(\t*).*$");
    private static final Comparator<NodeStyleSpan> COMPARATOR = Comparator.comparing(NodeStyleSpan::getNode, Comparator.comparingInt(Node::getBeginLine).thenComparing(Node::getBeginColumn));
    private final Node node;
    private final SyntaxHighlightingCodeArea codeArea;

    private NodeStyleSpan(Node node, SyntaxHighlightingCodeArea codeArea) {
        this.node = node;
        this.codeArea = codeArea;
    }

    public Node getNode() {
        return this.node;
    }

    public PositionSnapshot snapshot() {
        int lastKnownStart = this.getAbsolutePosition(this.node.getBeginLine(), this.node.getBeginColumn() - 1);
        int lastKnownEnd = this.getAbsolutePosition(this.node.getEndLine(), this.node.getEndColumn());
        return new PositionSnapshot(lastKnownStart, lastKnownEnd);
    }

    private int getAbsolutePosition(int line, int column) {
        return this.codeArea.getAbsolutePosition(line - 1, column) - this.indentationOffset(line - 1);
    }

    private int indentationOffset(int paragraph) {
        Paragraph p = this.codeArea.getParagraph(paragraph);
        Matcher m = TAB_INDENT.matcher(p.getText());
        if (m.matches()) {
            return m.group(1).length() * 7;
        }
        return 0;
    }

    public String toString() {
        return this.node.getXPathNodeName() + "@" + this.snapshot();
    }

    public static Comparator<NodeStyleSpan> documentOrderComparator() {
        return COMPARATOR;
    }

    public static NodeStyleSpan fromNode(Node node, SyntaxHighlightingCodeArea codeArea) {
        return new NodeStyleSpan(node, codeArea);
    }

    class PositionSnapshot
    implements TextAwareNodeWrapper {
        private int beginIndex;
        private int endIndex;

        PositionSnapshot(int beginIndex, int endIndex) {
            this.beginIndex = beginIndex;
            this.endIndex = endIndex;
        }

        public String toString() {
            return this.getNodeText() + "@[" + this.beginIndex + "," + this.endIndex + ']';
        }

        @Override
        public String getNodeText() {
            return NodeStyleSpan.this.codeArea.getText(this.beginIndex, this.endIndex);
        }

        @Override
        public StyledDocument<Collection<String>, String, Collection<String>> getNodeRichText() {
            return NodeStyleSpan.this.codeArea.subDocument(this.beginIndex, this.endIndex);
        }

        int getBeginIndex() {
            return this.beginIndex;
        }

        int getEndIndex() {
            return this.endIndex;
        }

        int getLength() {
            return this.endIndex - this.beginIndex;
        }

        @Override
        public Node getNode() {
            return NodeStyleSpan.this.getNode();
        }
    }
}

