/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.fxdesigner.util.beans;

import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import net.sourceforge.pmd.util.fxdesigner.util.beans.BeanModelNodeSeq;
import net.sourceforge.pmd.util.fxdesigner.util.beans.BeanNodeVisitor;
import net.sourceforge.pmd.util.fxdesigner.util.beans.SettingsOwner;
import net.sourceforge.pmd.util.fxdesigner.util.beans.SettingsPersistenceUtil;
import net.sourceforge.pmd.util.fxdesigner.util.beans.SimpleBeanModelNode;
import org.apache.commons.beanutils.PropertyUtils;

public class RestorePropertyVisitor
extends BeanNodeVisitor<SettingsOwner> {
    @Override
    public void visit(SimpleBeanModelNode model, SettingsOwner target) {
        if (model == null) {
            return;
        }
        if (target == null) {
            throw new IllegalArgumentException();
        }
        if (target.getClass() != model.getNodeType()) {
            throw new IllegalArgumentException("Incorrect settings restoration target, expected " + model.getNodeType() + ", actual " + target.getClass());
        }
        Map<String, PropertyDescriptor> descriptors = Arrays.stream(PropertyUtils.getPropertyDescriptors((Object)target)).filter(d -> d.getReadMethod() != null && d.getReadMethod().isAnnotationPresent(SettingsPersistenceUtil.PersistentProperty.class)).collect(Collectors.toMap(FeatureDescriptor::getName, d -> d));
        for (Map.Entry<String, Object> entry : model.getSettingsValues().entrySet()) {
            if (!descriptors.containsKey(entry.getKey())) continue;
            try {
                PropertyUtils.setProperty((Object)target, (String)entry.getKey(), (Object)entry.getValue());
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                System.err.println("Error setting property " + entry.getKey() + " on a " + target.getClass().getSimpleName());
                e.printStackTrace();
            }
        }
        for (BeanModelNodeSeq beanModelNodeSeq : model.getSequenceProperties()) {
            this.visit(beanModelNodeSeq, target);
        }
        for (SettingsOwner settingsOwner : target.getChildrenSettingsNodes()) {
            model.getChildrenByType().get(settingsOwner.getClass()).accept(this, settingsOwner);
        }
    }

    @Override
    public void visit(BeanModelNodeSeq<?> model, SettingsOwner target) {
        Collection container;
        if (model == null) {
            return;
        }
        if (target == null) {
            throw new IllegalArgumentException();
        }
        try {
            Collection tmp;
            container = tmp = (Collection)PropertyUtils.getProperty((Object)target, (String)model.getPropertyName());
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return;
        }
        Iterator existingItems = container.iterator();
        Class<?> itemType = null;
        ArrayList<SettingsOwner> itemsToAdd = new ArrayList<SettingsOwner>();
        for (SimpleBeanModelNode child : model.getChildrenNodes()) {
            SettingsOwner item;
            if (existingItems.hasNext()) {
                item = (SettingsOwner)existingItems.next();
            } else {
                if (itemType == null) {
                    itemType = child.getNodeType();
                }
                try {
                    item = (SettingsOwner)itemType.newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    e.printStackTrace();
                    continue;
                }
            }
            child.accept(this, item);
            itemsToAdd.add(item);
        }
        container.addAll(itemsToAdd);
        try {
            PropertyUtils.setProperty((Object)target, (String)model.getPropertyName(), (Object)container);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }
}

