/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.fxdesigner;

import java.io.IOException;
import java.net.URL;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventType;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextArea;
import javafx.scene.control.TitledPane;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.rule.XPathRule;
import net.sourceforge.pmd.util.fxdesigner.DesignerRoot;
import net.sourceforge.pmd.util.fxdesigner.MainDesignerController;
import net.sourceforge.pmd.util.fxdesigner.model.LogEntry;
import net.sourceforge.pmd.util.fxdesigner.model.ObservableXPathRuleBuilder;
import net.sourceforge.pmd.util.fxdesigner.model.XPathEvaluationException;
import net.sourceforge.pmd.util.fxdesigner.model.XPathEvaluator;
import net.sourceforge.pmd.util.fxdesigner.model.XPathSuggestions;
import net.sourceforge.pmd.util.fxdesigner.popups.ExportXPathWizardController;
import net.sourceforge.pmd.util.fxdesigner.util.DesignerUtil;
import net.sourceforge.pmd.util.fxdesigner.util.PropertyDescriptorSpec;
import net.sourceforge.pmd.util.fxdesigner.util.TextAwareNodeWrapper;
import net.sourceforge.pmd.util.fxdesigner.util.beans.SettingsOwner;
import net.sourceforge.pmd.util.fxdesigner.util.beans.SettingsPersistenceUtil;
import net.sourceforge.pmd.util.fxdesigner.util.codearea.SyntaxHighlightingCodeArea;
import net.sourceforge.pmd.util.fxdesigner.util.codearea.syntaxhighlighting.XPathSyntaxHighlighter;
import net.sourceforge.pmd.util.fxdesigner.util.controls.ContextMenuWithNoArrows;
import net.sourceforge.pmd.util.fxdesigner.util.controls.PropertyTableView;
import net.sourceforge.pmd.util.fxdesigner.util.controls.XpathViolationListCell;
import org.apache.commons.lang3.StringUtils;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;
import org.reactfx.EventStream;
import org.reactfx.EventStreams;
import org.reactfx.collection.LiveArrayList;
import org.reactfx.util.Tuples;
import org.reactfx.value.Val;
import org.reactfx.value.Var;

public class XPathPanelController
implements Initializable,
SettingsOwner {
    private static final Duration XPATH_REFRESH_DELAY = Duration.ofMillis(100L);
    private final DesignerRoot designerRoot;
    private final MainDesignerController parent;
    private final XPathEvaluator xpathEvaluator = new XPathEvaluator();
    private final ObservableXPathRuleBuilder ruleBuilder = new ObservableXPathRuleBuilder();
    @FXML
    private PropertyTableView propertyTableView;
    @FXML
    private SyntaxHighlightingCodeArea xpathExpressionArea;
    @FXML
    private TitledPane violationsTitledPane;
    @FXML
    private ListView<TextAwareNodeWrapper> xpathResultListView;
    private ChoiceBox<String> xpathVersionChoiceBox;

    public XPathPanelController(DesignerRoot owner, MainDesignerController mainController) {
        this.designerRoot = owner;
        this.parent = mainController;
        this.getRuleBuilder().setClazz(XPathRule.class);
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.xpathExpressionArea.setSyntaxHighlighter(new XPathSyntaxHighlighter());
        this.initGenerateXPathFromStackTrace();
        this.xpathResultListView.setCellFactory(v -> new XpathViolationListCell());
        EventStreams.valuesOf((ObservableValue)this.xpathResultListView.getSelectionModel().selectedItemProperty()).conditionOn((ObservableValue)this.xpathResultListView.focusedProperty()).filter(Objects::nonNull).map(TextAwareNodeWrapper::getNode).subscribe(this.parent::onNodeItemSelected);
        Platform.runLater(this::bindToParent);
        this.xpathExpressionArea.richChanges().filter(t -> !t.isIdentity()).successionEnds(XPATH_REFRESH_DELAY).or(this.xpathVersionProperty().changes()).subscribe(tick -> this.parent.refreshXPathResults());
        this.initialiseAutoCompletion();
    }

    private void initialiseAutoCompletion() {
        EventStream changesEventStream = this.xpathExpressionArea.plainTextChanges().map(characterChanges -> {
            if (((String)characterChanges.getRemoved()).length() > 0) {
                return characterChanges.getRemovalEnd() - 1;
            }
            return characterChanges.getInsertionEnd();
        });
        EventStream keyCombo = EventStreams.eventsOf((Node)this.xpathExpressionArea, (EventType)KeyEvent.KEY_PRESSED).filter(key -> key.isControlDown() && key.getCode().equals((Object)KeyCode.SPACE)).map(searchPoint -> this.xpathExpressionArea.getCaretPosition());
        ContextMenuWithNoArrows autoCompletePopup = new ContextMenuWithNoArrows();
        autoCompletePopup.setId("xpathAutocomplete");
        autoCompletePopup.setHideOnEscape(true);
        EventStreams.merge((EventStream[])new EventStream[]{keyCombo, changesEventStream}).map(searchPoint -> {
            int indexOfSlash = this.xpathExpressionArea.getText().lastIndexOf("/", searchPoint - 1) + 1;
            String input = this.xpathExpressionArea.getText();
            if (searchPoint > input.length()) {
                searchPoint = input.length();
            }
            input = input.substring(indexOfSlash, (int)searchPoint);
            return Tuples.t((Object)indexOfSlash, (Object)input);
        }).filter(t -> StringUtils.isAlpha((CharSequence)((CharSequence)t._2))).subscribe(s -> this.autoComplete((Integer)s._1, (String)s._2, autoCompletePopup));
    }

    private void autoComplete(int slashPosition, String input, ContextMenu autoCompletePopup) {
        XPathSuggestions xPathSuggestions = new XPathSuggestions(this.parent.getLanguageVersion().getLanguage());
        List<String> suggestions = xPathSuggestions.getXPathSuggestions(input.trim());
        ArrayList<CustomMenuItem> resultToDisplay = new ArrayList<CustomMenuItem>();
        if (!suggestions.isEmpty()) {
            for (int i = 0; i < suggestions.size() && i < 5; ++i) {
                String searchResult = suggestions.get(i);
                Label entryLabel = new Label();
                entryLabel.setGraphic((Node)XPathPanelController.highlightXPathSuggestion(suggestions.get(i), input));
                entryLabel.setPrefHeight(5.0);
                CustomMenuItem item = new CustomMenuItem((Node)entryLabel, true);
                resultToDisplay.add(item);
                item.setOnAction(e -> {
                    this.xpathExpressionArea.replaceText(slashPosition, slashPosition + input.length(), searchResult);
                    autoCompletePopup.hide();
                });
            }
        }
        autoCompletePopup.getItems().setAll(resultToDisplay);
        this.xpathExpressionArea.getCharacterBoundsOnScreen(slashPosition, slashPosition + input.length()).ifPresent(bounds -> autoCompletePopup.show((Node)this.xpathExpressionArea, bounds.getMinX(), bounds.getMaxY()));
    }

    private static TextFlow highlightXPathSuggestion(String text, String match) {
        int filterIndex = text.toLowerCase(Locale.ROOT).indexOf(match.toLowerCase(Locale.ROOT));
        Text textBefore = new Text(text.substring(0, filterIndex));
        Text textAfter = new Text(text.substring(filterIndex + match.length()));
        Text textFilter = new Text(text.substring(filterIndex, filterIndex + match.length()));
        textFilter.setFill((Paint)Color.ORANGE);
        return new TextFlow(new Node[]{textBefore, textFilter, textAfter});
    }

    private void initGenerateXPathFromStackTrace() {
        ContextMenu menu = new ContextMenu();
        MenuItem item = new MenuItem("Generate from stack trace...");
        item.setOnAction(e -> {
            try {
                Stage popup = new Stage();
                FXMLLoader loader = new FXMLLoader(DesignerUtil.getFxml("generate-xpath-from-stack-trace.fxml"));
                Parent root = (Parent)loader.load();
                Button button = (Button)loader.getNamespace().get((Object)"generateButton");
                TextArea area = (TextArea)loader.getNamespace().get((Object)"stackTraceArea");
                ValidationSupport validation = new ValidationSupport();
                validation.registerValidator((Control)area, Validator.createEmptyValidator((String)"The stack trace may not be empty"));
                button.disableProperty().bind((ObservableValue)validation.invalidProperty());
                button.setOnAction(f -> {
                    DesignerUtil.stackTraceToXPath(area.getText()).ifPresent(arg_0 -> ((SyntaxHighlightingCodeArea)this.xpathExpressionArea).replaceText(arg_0));
                    popup.close();
                });
                popup.setScene(new Scene(root));
                popup.initStyle(StageStyle.UTILITY);
                popup.initModality(Modality.WINDOW_MODAL);
                popup.initOwner((Window)this.designerRoot.getMainStage());
                popup.show();
            }
            catch (IOException e1) {
                throw new RuntimeException(e1);
            }
        });
        menu.getItems().add((Object)item);
        this.xpathExpressionArea.addEventHandler(MouseEvent.MOUSE_CLICKED, t -> {
            if (t.getButton() == MouseButton.SECONDARY) {
                menu.show((Node)this.xpathExpressionArea, t.getScreenX(), t.getScreenY());
            }
        });
    }

    private void bindToParent() {
        DesignerUtil.rewire(this.getRuleBuilder().languageProperty(), Val.map(this.parent.languageVersionProperty(), LanguageVersion::getLanguage));
        DesignerUtil.rewire(this.getRuleBuilder().xpathVersionProperty(), this.parent.xpathVersionProperty());
        DesignerUtil.rewire(this.getRuleBuilder().xpathExpressionProperty(), this.xpathExpressionProperty());
        DesignerUtil.rewire(this.getRuleBuilder().rulePropertiesProperty(), this.propertyTableView.rulePropertiesProperty(), this.propertyTableView::setRuleProperties);
    }

    public void initialiseVersionChoiceBox(ChoiceBox<String> choiceBox) {
        this.xpathVersionChoiceBox = choiceBox;
        ObservableList versionItems = choiceBox.getItems();
        versionItems.add((Object)"1.0");
        versionItems.add((Object)"1.0 compatibility");
        versionItems.add((Object)"2.0");
        this.xpathVersionChoiceBox.getSelectionModel().select((Object)"2.0");
        choiceBox.setConverter(DesignerUtil.stringConverter(s -> "XPath " + s, s -> s.substring(6)));
    }

    public void evaluateXPath(net.sourceforge.pmd.lang.ast.Node compilationUnit, LanguageVersion version) {
        try {
            String xpath = this.getXpathExpression();
            if (StringUtils.isBlank((CharSequence)xpath)) {
                this.invalidateResults(false);
                return;
            }
            ObservableList results = FXCollections.observableArrayList(this.xpathEvaluator.evaluateQuery(compilationUnit, version, this.getXpathVersion(), xpath, (List<PropertyDescriptorSpec>)this.ruleBuilder.getRuleProperties()));
            this.xpathResultListView.setItems((ObservableList)results.stream().map(this.parent::wrapNode).collect(Collectors.toCollection(LiveArrayList::new)));
            this.parent.highlightXPathResults((List<net.sourceforge.pmd.lang.ast.Node>)results);
            this.violationsTitledPane.setText("Matched nodes\t(" + results.size() + ")");
        }
        catch (XPathEvaluationException e) {
            this.invalidateResults(true);
            this.designerRoot.getLogger().logEvent(new LogEntry(e, LogEntry.Category.XPATH_EVALUATION_EXCEPTION));
        }
        this.xpathResultListView.refresh();
    }

    public List<net.sourceforge.pmd.lang.ast.Node> runXPathQuery(net.sourceforge.pmd.lang.ast.Node compilationUnit, LanguageVersion version, String query) throws XPathEvaluationException {
        return this.xpathEvaluator.evaluateQuery(compilationUnit, version, "2.0", query, (List<PropertyDescriptorSpec>)this.ruleBuilder.getRuleProperties());
    }

    public void invalidateResults(boolean error) {
        this.xpathResultListView.getItems().clear();
        this.parent.resetXPathResults();
        this.violationsTitledPane.setText("Matched nodes" + (error ? "\t(error)" : ""));
    }

    public void showExportXPathToRuleWizard() throws IOException {
        ExportXPathWizardController wizard = new ExportXPathWizardController((ObservableValue<String>)this.xpathExpressionProperty());
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("fxml/xpath-export-wizard.fxml"));
        loader.setController((Object)wizard);
        Stage dialog = new Stage();
        dialog.initOwner((Window)this.designerRoot.getMainStage());
        dialog.setOnCloseRequest(e -> wizard.shutdown());
        dialog.initModality(Modality.WINDOW_MODAL);
        Parent root = (Parent)loader.load();
        Scene scene = new Scene(root);
        dialog.setScene(scene);
        dialog.show();
    }

    @SettingsPersistenceUtil.PersistentProperty
    public String getXpathExpression() {
        return this.xpathExpressionArea.getText();
    }

    public void setXpathExpression(String expression) {
        this.xpathExpressionArea.replaceText(expression);
    }

    public Val<String> xpathExpressionProperty() {
        return Val.wrap((ObservableValue)this.xpathExpressionArea.textProperty());
    }

    @SettingsPersistenceUtil.PersistentProperty
    public String getXpathVersion() {
        return this.getRuleBuilder().getXpathVersion();
    }

    public void setXpathVersion(String xpathVersion) {
        this.getRuleBuilder().setXpathVersion(xpathVersion);
    }

    public Var<String> xpathVersionProperty() {
        return this.getRuleBuilder().xpathVersionProperty();
    }

    private ObservableXPathRuleBuilder getRuleBuilder() {
        return this.ruleBuilder;
    }

    @Override
    public List<SettingsOwner> getChildrenSettingsNodes() {
        return Collections.singletonList(this.getRuleBuilder());
    }
}

