/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.fxdesigner;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.symboltable.NameOccurrence;
import net.sourceforge.pmd.util.ClasspathClassLoader;
import net.sourceforge.pmd.util.fxdesigner.DesignerRoot;
import net.sourceforge.pmd.util.fxdesigner.MainDesignerController;
import net.sourceforge.pmd.util.fxdesigner.model.ASTManager;
import net.sourceforge.pmd.util.fxdesigner.model.ParseAbortedException;
import net.sourceforge.pmd.util.fxdesigner.popups.AuxclasspathSetupController;
import net.sourceforge.pmd.util.fxdesigner.util.TextAwareNodeWrapper;
import net.sourceforge.pmd.util.fxdesigner.util.beans.SettingsOwner;
import net.sourceforge.pmd.util.fxdesigner.util.beans.SettingsPersistenceUtil;
import net.sourceforge.pmd.util.fxdesigner.util.codearea.AvailableSyntaxHighlighters;
import net.sourceforge.pmd.util.fxdesigner.util.codearea.HighlightLayerCodeArea;
import net.sourceforge.pmd.util.fxdesigner.util.controls.ASTTreeCell;
import net.sourceforge.pmd.util.fxdesigner.util.controls.ASTTreeItem;
import net.sourceforge.pmd.util.fxdesigner.util.controls.TreeViewWrapper;
import org.apache.commons.lang3.StringUtils;
import org.fxmisc.richtext.LineNumberFactory;
import org.reactfx.EventStreams;
import org.reactfx.value.Val;
import org.reactfx.value.Var;

public class SourceEditorController
implements Initializable,
SettingsOwner {
    private static final Duration AST_REFRESH_DELAY = Duration.ofMillis(100L);
    @FXML
    private Label astTitleLabel;
    @FXML
    private TreeView<net.sourceforge.pmd.lang.ast.Node> astTreeView;
    @FXML
    private HighlightLayerCodeArea<StyleLayerIds> codeEditorArea;
    private ASTManager astManager;
    private TreeViewWrapper<net.sourceforge.pmd.lang.ast.Node> treeViewWrapper;
    private final MainDesignerController parent;
    private Var<net.sourceforge.pmd.lang.ast.Node> currentFocusNode = Var.newSimpleVar(null);
    private ASTTreeItem selectedTreeItem;
    private Var<List<File>> auxclasspathFiles = Var.newSimpleVar(Collections.emptyList());
    private final Val<ClassLoader> auxclasspathClassLoader = this.auxclasspathFiles.map(fileList -> {
        try {
            return new ClasspathClassLoader(fileList, SourceEditorController.class.getClassLoader());
        }
        catch (IOException e) {
            e.printStackTrace();
            return SourceEditorController.class.getClassLoader();
        }
    });

    public SourceEditorController(DesignerRoot owner, MainDesignerController mainController) {
        this.parent = mainController;
        this.astManager = new ASTManager(owner);
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.treeViewWrapper = new TreeViewWrapper<net.sourceforge.pmd.lang.ast.Node>(this.astTreeView);
        this.astTreeView.setCellFactory(treeView -> new ASTTreeCell(this.parent));
        this.languageVersionProperty().values().filterMap(Objects::nonNull, LanguageVersion::getLanguage).distinct().subscribe(this::updateSyntaxHighlighter);
        EventStreams.valuesOf((ObservableValue)this.astTreeView.getSelectionModel().selectedItemProperty()).filterMap(Objects::nonNull, TreeItem::getValue).subscribe(this.parent::onNodeItemSelected);
        this.codeEditorArea.plainTextChanges().filter(t -> !t.isIdentity()).successionEnds(AST_REFRESH_DELAY).or(this.auxclasspathClassLoader.changes()).or(this.languageVersionProperty().changes()).subscribe(tick -> {
            tick.ifRight(c -> this.astTreeView.setRoot(null));
            Platform.runLater(this.parent::refreshAST);
        });
        this.codeEditorArea.setParagraphGraphicFactory(this.lineNumberFactory());
    }

    private IntFunction<Node> lineNumberFactory() {
        IntFunction base = LineNumberFactory.get(this.codeEditorArea);
        Val activePar = Val.wrap((ObservableValue)this.codeEditorArea.currentParagraphProperty());
        return idx -> {
            Node label = (Node)base.apply(idx);
            activePar.conditionOnShowing(label).values().subscribe(p -> label.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"has-caret"), idx == p));
            this.currentFocusNode.conditionOnShowing(label).values().subscribe(n -> label.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)"is-focus-node"), n != null && idx + 1 <= n.getEndLine() && idx + 1 >= n.getBeginLine()));
            return label;
        };
    }

    public Optional<net.sourceforge.pmd.lang.ast.Node> refreshAST() {
        Optional<net.sourceforge.pmd.lang.ast.Node> current;
        String source = this.getText();
        if (StringUtils.isBlank((CharSequence)source)) {
            this.astTreeView.setRoot(null);
            return Optional.empty();
        }
        try {
            current = this.astManager.updateIfChanged(source, (ClassLoader)this.auxclasspathClassLoader.getValue());
        }
        catch (ParseAbortedException e) {
            this.astTitleLabel.setText("Abstract syntax tree (error)");
            return Optional.empty();
        }
        current.ifPresent(this::setUpToDateCompilationUnit);
        return current;
    }

    public void showAuxclasspathSetupPopup(DesignerRoot root) {
        new AuxclasspathSetupController(root).show(root.getMainStage(), (List)this.auxclasspathFiles.getValue(), arg_0 -> this.auxclasspathFiles.setValue(arg_0));
    }

    private void setUpToDateCompilationUnit(net.sourceforge.pmd.lang.ast.Node node) {
        this.parent.invalidateAst();
        this.astTitleLabel.setText("Abstract syntax tree");
        ASTTreeItem root = ASTTreeItem.getRoot(node);
        this.astTreeView.setRoot((TreeItem)root);
    }

    private void updateSyntaxHighlighter(Language language) {
        this.codeEditorArea.setSyntaxHighlighter(AvailableSyntaxHighlighters.getHighlighterForLanguage(language).orElse(null));
    }

    public void clearErrorNodes() {
        this.codeEditorArea.clearStyleLayer(StyleLayerIds.ERROR);
    }

    public void clearNameOccurences() {
        this.codeEditorArea.clearStyleLayer(StyleLayerIds.ERROR);
    }

    public void clearXPathHighlight() {
        this.codeEditorArea.clearStyleLayer(StyleLayerIds.XPATH_RESULT);
    }

    public void setFocusNode(net.sourceforge.pmd.lang.ast.Node node) {
        if (Objects.equals(node, this.currentFocusNode.getValue())) {
            return;
        }
        this.codeEditorArea.styleNodes(node == null ? Collections.emptyList() : Collections.singleton(node), StyleLayerIds.FOCUS, true);
        if (node != null) {
            this.scrollEditorToNode(node);
        }
        this.currentFocusNode.setValue((Object)node);
    }

    public void highlightXPathResults(Collection<? extends net.sourceforge.pmd.lang.ast.Node> nodes) {
        this.codeEditorArea.styleNodes(nodes, StyleLayerIds.XPATH_RESULT, true);
    }

    public void highlightNameOccurrences(Collection<? extends NameOccurrence> occs) {
        this.codeEditorArea.styleNodes(occs.stream().map(NameOccurrence::getLocation).collect(Collectors.toList()), StyleLayerIds.NAME_OCCURENCE, true);
    }

    public void highlightErrorNodes(Collection<? extends net.sourceforge.pmd.lang.ast.Node> nodes) {
        this.codeEditorArea.styleNodes(nodes, StyleLayerIds.ERROR, true);
        if (!nodes.isEmpty()) {
            this.scrollEditorToNode(nodes.iterator().next());
        }
    }

    private void scrollEditorToNode(net.sourceforge.pmd.lang.ast.Node node) {
        this.codeEditorArea.moveTo(node.getBeginLine() - 1, 0);
        if (this.codeEditorArea.getVisibleParagraphs().size() < 1) {
            return;
        }
        int visibleLength = this.codeEditorArea.lastVisibleParToAllParIndex() - this.codeEditorArea.firstVisibleParToAllParIndex();
        if (node.getEndLine() - node.getBeginLine() > visibleLength || node.getBeginLine() < this.codeEditorArea.firstVisibleParToAllParIndex()) {
            this.codeEditorArea.showParagraphAtTop(Math.max(node.getBeginLine() - 2, 0));
        } else if (node.getEndLine() > this.codeEditorArea.lastVisibleParToAllParIndex()) {
            this.codeEditorArea.showParagraphAtBottom(Math.min(node.getEndLine(), this.codeEditorArea.getParagraphs().size()));
        }
    }

    public void clearStyleLayers() {
        this.codeEditorArea.clearStyleLayers();
    }

    public void focusNodeInTreeView(net.sourceforge.pmd.lang.ast.Node node) {
        MultipleSelectionModel selectionModel = this.astTreeView.getSelectionModel();
        if (this.selectedTreeItem == null && node != null || this.selectedTreeItem != null && !Objects.equals(node, this.selectedTreeItem.getValue())) {
            ASTTreeItem found = ((ASTTreeItem)this.astTreeView.getRoot()).findItem(node);
            if (found != null) {
                selectionModel.select((Object)found);
            }
            this.selectedTreeItem = found;
            this.astTreeView.getFocusModel().focus(selectionModel.getSelectedIndex());
            if (!this.treeViewWrapper.isIndexVisible(selectionModel.getSelectedIndex())) {
                this.astTreeView.scrollTo(selectionModel.getSelectedIndex());
            }
        }
    }

    public void moveCaret(int line, int column) {
        this.codeEditorArea.moveTo(line, column);
        this.codeEditorArea.requestFollowCaret();
    }

    public TextAwareNodeWrapper wrapNode(net.sourceforge.pmd.lang.ast.Node node) {
        return this.codeEditorArea.wrapNode(node);
    }

    @SettingsPersistenceUtil.PersistentProperty
    public LanguageVersion getLanguageVersion() {
        return this.astManager.getLanguageVersion();
    }

    public void setLanguageVersion(LanguageVersion version) {
        this.astManager.setLanguageVersion(version);
    }

    public Var<LanguageVersion> languageVersionProperty() {
        return this.astManager.languageVersionProperty();
    }

    public Optional<net.sourceforge.pmd.lang.ast.Node> getCompilationUnit() {
        return this.astManager.getCompilationUnit();
    }

    @SettingsPersistenceUtil.PersistentProperty
    public String getText() {
        return this.codeEditorArea.getText();
    }

    public void setText(String expression) {
        this.codeEditorArea.replaceText(expression);
    }

    public Val<String> textProperty() {
        return Val.wrap((ObservableValue)this.codeEditorArea.textProperty());
    }

    @SettingsPersistenceUtil.PersistentProperty
    public String getAuxclasspathFiles() {
        return ((List)this.auxclasspathFiles.getValue()).stream().map(File::getAbsolutePath).collect(Collectors.joining(File.pathSeparator));
    }

    public void setAuxclasspathFiles(String files) {
        List newVal = Arrays.stream(files.split(File.pathSeparator)).map(File::new).collect(Collectors.toList());
        this.auxclasspathFiles.setValue(newVal);
    }

    private static enum StyleLayerIds implements HighlightLayerCodeArea.LayerId
    {
        FOCUS,
        NAME_OCCURENCE,
        ERROR,
        XPATH_RESULT;

        private final String styleClass = this.name().toLowerCase(Locale.ROOT).replace('_', '-') + "-highlight";

        @Override
        public String getStyleClass() {
            return this.styleClass;
        }
    }
}

