/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.util;

public class EditDistance {
    private static final int INSERT_OR_DELETE_COST = 2;

    private static int minimum(int a, int b, int c) {
        if (a > b) {
            return Math.min(b, c);
        }
        return Math.min(a, c);
    }

    private static int distance(char a, char b) {
        if (a == b) {
            return 0;
        }
        if (Character.toLowerCase(a) == Character.toLowerCase(b)) {
            return 1;
        }
        return 2;
    }

    public static double editDistanceRatio(String str1, String str2) {
        double distance = EditDistance.editDistance(str1, str2);
        int maxDistance = 2 * Math.max(str1.length(), str2.length());
        return Math.min(distance / (double)maxDistance, distance / 4.0);
    }

    public static int editDistance(String str1, String str2) {
        int n2;
        int n1 = str1.length();
        int diff = Math.abs(n1 - (n2 = str2.length()));
        if (diff > 6) {
            return 2 * Math.max(n1, n2);
        }
        return EditDistance.editDistance1(str1, str2);
    }

    public static int editDistance0(String str1, String str2) {
        int i;
        int n1 = str1.length();
        int n2 = str2.length();
        int[][] distance = new int[n1 + 1][];
        for (i = 0; i <= n1; ++i) {
            distance[i] = new int[n2 + 1];
            distance[i][0] = 2 * i;
        }
        for (int j = 1; j <= n2; ++j) {
            distance[0][j] = 2 * j;
        }
        for (i = 1; i <= n1; ++i) {
            for (int j = 1; j <= n2; ++j) {
                distance[i][j] = EditDistance.minimum(distance[i - 1][j] + 2, distance[i][j - 1] + 2, distance[i - 1][j - 1] + EditDistance.distance(str1.charAt(i - 1), str2.charAt(j - 1)));
            }
        }
        return distance[n1][n2];
    }

    public static int editDistance1(String str1, String str2) {
        int n1 = str1.length();
        int n2 = str2.length();
        int[] distance = new int[n2 + 1];
        int[] oldDistance = new int[n2 + 1];
        for (int j = 1; j <= n2; ++j) {
            oldDistance[j] = 2 * j;
        }
        for (int i = 1; i <= n1; ++i) {
            distance[0] = 2 * i;
            for (int j = 1; j <= n2; ++j) {
                distance[j] = EditDistance.minimum(oldDistance[j] + 2, distance[j - 1] + 2, oldDistance[j - 1] + EditDistance.distance(str1.charAt(i - 1), str2.charAt(j - 1)));
            }
            int[] tmp = oldDistance;
            oldDistance = distance;
            distance = tmp;
        }
        int result = oldDistance[n2];
        assert (result == EditDistance.editDistance0(str1, str2));
        return result;
    }
}

