/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.detect.FindNoSideEffectMethods;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.MethodGen;

public class RepeatedConditionals
extends OpcodeStackDetector {
    BugReporter bugReporter;
    private final FindNoSideEffectMethods.NoSideEffectMethodsDatabase noSideEffectMethods;
    int oldPC;
    LinkedList<Integer> emptyStackLocations = new LinkedList();
    LinkedList<Integer> prevOpcodeLocations = new LinkedList();
    Map<Integer, Integer> branchTargets = new HashMap<Integer, Integer>();

    public RepeatedConditionals(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.noSideEffectMethods = Global.getAnalysisCache().getDatabase(FindNoSideEffectMethods.NoSideEffectMethodsDatabase.class);
        this.reset();
    }

    @Override
    public void visit(Code code) {
        boolean interesting = true;
        if (interesting) {
            super.visit(code);
            this.reset();
        }
    }

    @Override
    public void sawBranchTo(int pc) {
        this.branchTargets.put(this.getPC(), pc);
    }

    @Override
    public void sawOpcode(int seen) {
        if (this.hasSideEffect(seen)) {
            this.reset();
        } else if (this.stack.getStackDepth() == 0) {
            if (this.emptyStackLocations.size() > 1) {
                for (int n = 1; n <= this.emptyStackLocations.size() / 2; ++n) {
                    boolean identicalCheck;
                    int first = this.emptyStackLocations.get(this.emptyStackLocations.size() - 2 * n);
                    int second = this.emptyStackLocations.get(this.emptyStackLocations.size() - n);
                    int third = this.getPC();
                    if (third - second != second - first) continue;
                    int endOfFirstSegment = this.prevOpcodeLocations.get(this.emptyStackLocations.size() - n);
                    int endOfSecondSegment = this.oldPC;
                    int opcodeAtEndOfFirst = this.getCodeByte(endOfFirstSegment);
                    int opcodeAtEndOfSecond = this.getCodeByte(endOfSecondSegment);
                    if (!RepeatedConditionals.isBranch(opcodeAtEndOfFirst) || !RepeatedConditionals.isBranch(opcodeAtEndOfSecond) || opcodeAtEndOfFirst == 167 || opcodeAtEndOfSecond == 167 || opcodeAtEndOfFirst != opcodeAtEndOfSecond && !RepeatedConditionals.areOppositeBranches(opcodeAtEndOfFirst, opcodeAtEndOfSecond) || first == endOfFirstSegment) continue;
                    Integer firstTarget = this.branchTargets.get(endOfFirstSegment);
                    Integer secondTarget = this.branchTargets.get(endOfSecondSegment);
                    if (firstTarget == null || secondTarget == null || firstTarget >= second && firstTarget <= endOfSecondSegment || !this.compareCode(first, endOfFirstSegment, second, endOfSecondSegment, !(identicalCheck = firstTarget.equals(secondTarget) && opcodeAtEndOfFirst == opcodeAtEndOfSecond || firstTarget.intValue() == this.getPC() && opcodeAtEndOfFirst != opcodeAtEndOfSecond))) continue;
                    SourceLineAnnotation firstSourceLine = SourceLineAnnotation.fromVisitedInstructionRange(this.getClassContext(), this, first, endOfFirstSegment - 1);
                    SourceLineAnnotation secondSourceLine = SourceLineAnnotation.fromVisitedInstructionRange(this.getClassContext(), this, second, endOfSecondSegment - 1);
                    int priority = 1;
                    if (firstSourceLine.getStartLine() == -1 || firstSourceLine.getStartLine() != secondSourceLine.getEndLine()) {
                        ++priority;
                    }
                    if (this.stack.isJumpTarget(second)) {
                        ++priority;
                    }
                    if (!identicalCheck) {
                        priority += 2;
                    }
                    BugInstance bug = new BugInstance(this, "RpC_REPEATED_CONDITIONAL_TEST", priority).addClassAndMethod(this).add(firstSourceLine).add(secondSourceLine);
                    this.bugReporter.reportBug(bug);
                }
            }
            this.emptyStackLocations.add(this.getPC());
            this.prevOpcodeLocations.add(this.oldPC);
        }
        this.oldPC = this.getPC();
    }

    private boolean compareCode(int first, int endOfFirstSegment, int second, int endOfSecondSegment, boolean oppositeChecks) {
        if (endOfFirstSegment - first != endOfSecondSegment - second) {
            return false;
        }
        MethodGen methodGen = null;
        try {
            methodGen = Global.getAnalysisCache().getMethodAnalysis(MethodGen.class, this.getMethodDescriptor());
        }
        catch (CheckedAnalysisException checkedAnalysisException) {
            // empty catch block
        }
        if (methodGen == null) {
            byte[] code = this.getCode().getCode();
            for (int i = first; i < endOfFirstSegment; ++i) {
                if (code[i] == code[i - first + second]) continue;
                return false;
            }
            return true;
        }
        InstructionHandle firstHandle = methodGen.getInstructionList().findHandle(first);
        InstructionHandle secondHandle = methodGen.getInstructionList().findHandle(second);
        while (firstHandle != null && secondHandle != null) {
            if (firstHandle.getPosition() >= endOfFirstSegment) {
                return secondHandle.getPosition() >= endOfSecondSegment;
            }
            if (secondHandle.getPosition() >= endOfSecondSegment) {
                return firstHandle.getPosition() >= endOfFirstSegment;
            }
            Instruction firstInstruction = firstHandle.getInstruction();
            Instruction secondInstruction = secondHandle.getInstruction();
            if (firstInstruction instanceof BranchInstruction && secondInstruction instanceof BranchInstruction) {
                short secondOpcode;
                short firstOpcode = firstInstruction.getOpcode();
                if (firstOpcode != (secondOpcode = secondInstruction.getOpcode())) {
                    return false;
                }
                int firstTarget = ((BranchInstruction)firstInstruction).getTarget().getPosition();
                int secondTarget = ((BranchInstruction)secondInstruction).getTarget().getPosition();
                if (firstTarget == second ? oppositeChecks || secondTarget <= endOfSecondSegment : (firstTarget < first || firstTarget > endOfFirstSegment || firstTarget - first != secondTarget - second) && firstTarget != secondTarget) {
                    return false;
                }
            } else if (!firstInstruction.equals((Object)secondInstruction)) {
                return false;
            }
            firstHandle = firstHandle.getNext();
            secondHandle = secondHandle.getNext();
        }
        return false;
    }

    private boolean hasSideEffect(int seen) {
        if (seen == 182 || seen == 183 || seen == 185 || seen == 184) {
            return this.noSideEffectMethods.is(this.getMethodDescriptorOperand(), FindNoSideEffectMethods.MethodSideEffectStatus.SE, FindNoSideEffectMethods.MethodSideEffectStatus.OBJ);
        }
        return this.isRegisterStore() || this.isReturn(seen) || RepeatedConditionals.isSwitch(seen) || seen == 186 || seen == 181 || seen == 179;
    }

    private void reset() {
        this.emptyStackLocations.clear();
        this.prevOpcodeLocations.clear();
        this.branchTargets.clear();
        this.oldPC = -1;
    }
}

