/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.bcel.classfile.Code;

public class LostLoggerDueToWeakReference
extends OpcodeStackDetector {
    private static final List<MethodDescriptor> methods = Arrays.asList(new MethodDescriptor("java/util/logging/Logger", "getLogger", "(Ljava/lang/String;)Ljava/util/logging/Logger;", true), new MethodDescriptor("java/util/logging/Logger", "getLogger", "(Ljava/lang/String;Ljava/lang/String;)Ljava/util/logging/Logger;", true));
    final BugAccumulator bugAccumulator;
    final HashSet<String> namesOfSetterMethods = new HashSet();
    int sawGetLogger;
    boolean loggerEscaped;
    boolean loggerImported;

    public LostLoggerDueToWeakReference(BugReporter bugReporter) {
        this.bugAccumulator = new BugAccumulator(bugReporter);
        this.namesOfSetterMethods.add("addHandler");
        this.namesOfSetterMethods.add("setUseParentHandlers");
        this.namesOfSetterMethods.add("setLevel");
        this.namesOfSetterMethods.add("setFilter");
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        if (LostLoggerDueToWeakReference.hasInterestingMethod(classContext.getJavaClass().getConstantPool(), methods)) {
            super.visitClassContext(classContext);
        }
    }

    @Override
    public void visit(Code code) {
        if (this.getMethodSig().indexOf("Logger") == -1) {
            this.sawGetLogger = -1;
            this.loggerImported = false;
            this.loggerEscaped = false;
            super.visit(code);
            if (this.sawGetLogger >= 0 && !this.loggerEscaped && !this.loggerImported) {
                this.bugAccumulator.reportAccumulatedBugs();
            } else {
                this.bugAccumulator.clearBugs();
            }
        }
    }

    @Override
    public void sawOpcode(int seen) {
        if (this.loggerEscaped || this.loggerImported) {
            return;
        }
        switch (seen) {
            case 184: {
                if ("java/util/logging/Logger".equals(this.getClassConstantOperand()) && "getLogger".equals(this.getNameConstantOperand())) {
                    OpcodeStack.Item item = this.stack.getStackItem(0);
                    if ("".equals(item.getConstant())) break;
                    this.sawGetLogger = this.getPC();
                    break;
                }
                this.checkForImport();
                break;
            }
            case 182: {
                if ("java/util/logging/Logger".equals(this.getClassConstantOperand()) && this.namesOfSetterMethods.contains(this.getNameConstantOperand())) {
                    int priority = 1;
                    if (this.getMethod().isStatic() && "main".equals(this.getMethodName()) && "([Ljava/lang/String;)V".equals(this.getMethodSig())) {
                        priority = 2;
                    }
                    OpcodeStack.Item item = this.stack.getItemMethodInvokedOn(this);
                    BugInstance bug = new BugInstance(this, "LG_LOST_LOGGER_DUE_TO_WEAK_REFERENCE", priority).addClassAndMethod(this).addValueSource(item, this);
                    this.bugAccumulator.accumulateBug(bug, this);
                    break;
                }
                this.checkForImport();
                this.checkForMethodExportImport();
                break;
            }
            case 183: 
            case 185: {
                this.checkForImport();
                this.checkForMethodExportImport();
                break;
            }
            case 192: {
                String sig = this.getClassConstantOperand();
                if (sig.indexOf("Logger") < 0) break;
                this.loggerImported = true;
                break;
            }
            case 178: 
            case 180: {
                this.checkForImport();
                break;
            }
            case 179: 
            case 181: {
                this.checkForFieldEscape();
                break;
            }
        }
    }

    private void checkForImport() {
        if (this.getSigConstantOperand().endsWith("Logger;")) {
            this.loggerImported = true;
        }
    }

    private void checkForMethodExportImport() {
        int numArguments = PreorderVisitor.getNumberArguments(this.getSigConstantOperand());
        for (int i = 0; i < numArguments; ++i) {
            OpcodeStack.Item item = this.stack.getStackItem(i);
            if (!item.getSignature().endsWith("Logger;")) continue;
            this.loggerEscaped = true;
        }
        String sig = this.getSigConstantOperand();
        int pos = sig.indexOf(41);
        int loggerPos = sig.indexOf("Logger");
        if (0 <= loggerPos && loggerPos < pos) {
            this.loggerEscaped = true;
        }
    }

    private void checkForFieldEscape() {
        OpcodeStack.Item item;
        String sig = this.getSigConstantOperand();
        if (sig.indexOf("Logger") >= 0) {
            this.loggerEscaped = true;
        }
        if ((item = this.stack.getStackItem(0)).getSignature().endsWith("Logger;")) {
            this.loggerEscaped = true;
        }
    }
}

