/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.detect.FindNoSideEffectMethods;
import java.util.HashSet;
import java.util.Set;
import org.apache.bcel.classfile.Method;

public class FindDoubleCheck
extends OpcodeStackDetector {
    static final boolean DEBUG = false;
    int stage = 0;
    int startPC;
    int endPC;
    int assignPC;
    int count;
    boolean sawMonitorEnter;
    Set<FieldAnnotation> fields = new HashSet<FieldAnnotation>();
    Set<FieldAnnotation> twice = new HashSet<FieldAnnotation>();
    FieldAnnotation pendingFieldLoad;
    XField currentDoubleCheckField;
    int countSinceGetReference;
    int countSinceGetBoolean;
    private final BugReporter bugReporter;
    private final FindNoSideEffectMethods.NoSideEffectMethodsDatabase nse;

    public FindDoubleCheck(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.nse = Global.getAnalysisCache().getDatabase(FindNoSideEffectMethods.NoSideEffectMethodsDatabase.class);
    }

    @Override
    public void visit(Method obj) {
        super.visit(obj);
        this.fields.clear();
        this.twice.clear();
        this.stage = 0;
        this.count = 0;
        this.countSinceGetReference = 1000;
        this.countSinceGetBoolean = 1000;
        this.sawMonitorEnter = false;
        this.pendingFieldLoad = null;
        this.currentDoubleCheckField = null;
    }

    @Override
    public void sawOpcode(int seen) {
        if (seen == 194) {
            this.sawMonitorEnter = true;
        }
        if (seen == 180 || seen == 178) {
            this.pendingFieldLoad = FieldAnnotation.fromReferencedField(this);
            String sig = this.getSigConstantOperand();
            if ("Z".equals(sig)) {
                this.countSinceGetBoolean = 0;
                ++this.countSinceGetReference;
            } else if (sig.startsWith("L") || sig.startsWith("[")) {
                ++this.countSinceGetBoolean;
                this.countSinceGetReference = 0;
            }
        } else {
            ++this.countSinceGetReference;
        }
        switch (this.stage) {
            case 0: {
                int b;
                if (!((seen != 198 && seen != 199 || this.countSinceGetReference >= 5) && (seen != 153 && seen != 154 || this.countSinceGetBoolean >= 5) || (b = this.getBranchOffset()) <= 0 || seen == 198 && b > 9 || seen == 153 && b > 9 && b < 34 || seen == 154 && b > 9 && b < 34 || this.sawMonitorEnter)) {
                    this.fields.add(this.pendingFieldLoad);
                    this.startPC = this.getPC();
                    this.stage = 1;
                }
                this.count = 0;
                break;
            }
            case 1: {
                if (seen == 194) {
                    this.stage = 2;
                    this.count = 0;
                    break;
                }
                if ((seen == 198 || seen == 199) && this.countSinceGetReference < 5 || (seen == 153 || seen == 154) && this.countSinceGetBoolean < 5) {
                    int b = this.getBranchOffset();
                    if (b <= 0 || seen != 199 && b >= 10) break;
                    this.fields.add(this.pendingFieldLoad);
                    this.startPC = this.getPC();
                    this.count = 0;
                    break;
                }
                ++this.count;
                if (this.count <= 10) break;
                this.stage = 0;
                break;
            }
            case 2: {
                if (((seen == 198 || seen == 199) && this.countSinceGetReference < 5 || (seen == 153 || seen == 154) && this.countSinceGetBoolean < 5) && this.getBranchOffset() >= 0 && this.fields.contains(this.pendingFieldLoad)) {
                    this.endPC = this.getPC();
                    ++this.stage;
                    this.twice.add(this.pendingFieldLoad);
                    break;
                }
                ++this.count;
                if (this.count <= 10) break;
                this.stage = 0;
                break;
            }
            case 3: {
                FieldAnnotation f;
                if (seen != 181 && seen != 179 || !this.twice.contains(f = FieldAnnotation.fromReferencedField(this)) || this.getNameConstantOperand().startsWith("class$") || "Ljava/lang/String;".equals(this.getSigConstantOperand())) break;
                XField declaration = this.getXFieldOperand();
                if (declaration == null || !declaration.isVolatile()) {
                    this.bugReporter.reportBug(new BugInstance(this, "DC_DOUBLECHECK", 2).addClassAndMethod(this).addField(f).describe("FIELD_ON").addSourceLineRange(this, this.startPC, this.endPC));
                } else if (declaration.isReferenceType()) {
                    this.currentDoubleCheckField = declaration;
                    this.assignPC = this.getPC();
                }
                ++this.stage;
                break;
            }
            case 4: {
                if (this.currentDoubleCheckField == null) break;
                switch (seen) {
                    case 195: {
                        ++this.stage;
                        break;
                    }
                    case 182: 
                    case 183: 
                    case 185: {
                        if (!this.nse.is(this.getMethodDescriptorOperand(), FindNoSideEffectMethods.MethodSideEffectStatus.OBJ, FindNoSideEffectMethods.MethodSideEffectStatus.SE)) break;
                        this.checkStackValue(FindDoubleCheck.getNumberArguments(this.getMethodDescriptorOperand().getSignature()));
                        break;
                    }
                    case 181: {
                        this.checkStackValue(1);
                        break;
                    }
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: {
                        this.checkStackValue(2);
                    }
                }
                break;
            }
        }
    }

    private void checkStackValue(int arg) {
        OpcodeStack.Item item = this.getStack().getStackItem(arg);
        if (item.getXField() == this.currentDoubleCheckField) {
            this.bugReporter.reportBug(new BugInstance(this, "DC_PARTIALLY_CONSTRUCTED", 2).addClassAndMethod(this).addField(this.currentDoubleCheckField).describe("FIELD_ON").addSourceLine(this).addSourceLine(this, this.assignPC).describe("SOURCE_LINE_STORED"));
            ++this.stage;
        }
    }
}

