/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.jsr305;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierAnnotation;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierValue;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.util.DualKeyHashMap;
import java.util.HashMap;
import java.util.Map;

public class TypeQualifierDatabase {
    public static final boolean USE_DATABASE = SystemProperties.getBoolean("ctq.usedatabase", true);
    public static final boolean DEBUG = SystemProperties.getBoolean("ctq.db.debug");
    private final Map<MethodDescriptor, Map<TypeQualifierValue<?>, TypeQualifierAnnotation>> returnValueMap = new HashMap();
    private final DualKeyHashMap<MethodDescriptor, Integer, Map<TypeQualifierValue<?>, TypeQualifierAnnotation>> parameterMap = new DualKeyHashMap();

    public void setReturnValue(MethodDescriptor methodDesc, TypeQualifierValue<?> tqv, TypeQualifierAnnotation tqa) {
        Map<TypeQualifierValue<?>, TypeQualifierAnnotation> map = this.returnValueMap.get(methodDesc);
        if (map == null) {
            map = new HashMap();
            this.returnValueMap.put(methodDesc, map);
        }
        map.put(tqv, tqa);
        if (DEBUG) {
            System.out.println("tqdb: " + methodDesc + " for " + tqv + " ==> " + tqa);
        }
    }

    public TypeQualifierAnnotation getReturnValue(MethodDescriptor methodDesc, TypeQualifierValue<?> tqv) {
        Map<TypeQualifierValue<?>, TypeQualifierAnnotation> map = this.returnValueMap.get(methodDesc);
        if (map == null) {
            return null;
        }
        return map.get(tqv);
    }

    public void setParameter(MethodDescriptor methodDesc, int param, TypeQualifierValue<?> tqv, TypeQualifierAnnotation tqa) {
        Map<TypeQualifierValue<?>, TypeQualifierAnnotation> map = this.parameterMap.get(methodDesc, param);
        if (map == null) {
            map = new HashMap();
            this.parameterMap.put(methodDesc, param, map);
        }
        map.put(tqv, tqa);
        if (DEBUG) {
            System.out.println("tqdb: " + methodDesc + " parameter " + param + " for " + tqv + " ==> " + tqa);
        }
    }

    public TypeQualifierAnnotation getParameter(MethodDescriptor methodDesc, int param, TypeQualifierValue<?> tqv) {
        Map<TypeQualifierValue<?>, TypeQualifierAnnotation> map = this.parameterMap.get(methodDesc, param);
        if (map == null) {
            return null;
        }
        return map.get(tqv);
    }
}

