/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAllocationExpression;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotationMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotationTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTAnyTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTEnumBody;
import net.sourceforge.pmd.lang.java.ast.ASTEnumConstant;
import net.sourceforge.pmd.lang.java.ast.ASTEnumDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodOrConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTResource;
import net.sourceforge.pmd.lang.java.ast.AccessNode;
import net.sourceforge.pmd.lang.java.ast.MethodLikeNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import org.apache.commons.lang3.StringUtils;

public class UnnecessaryModifierRule
extends AbstractJavaRule {
    public UnnecessaryModifierRule() {
        this.addRuleChainVisit(ASTEnumDeclaration.class);
        this.addRuleChainVisit(ASTAnnotationTypeDeclaration.class);
        this.addRuleChainVisit(ASTClassOrInterfaceDeclaration.class);
        this.addRuleChainVisit(ASTMethodDeclaration.class);
        this.addRuleChainVisit(ASTResource.class);
        this.addRuleChainVisit(ASTFieldDeclaration.class);
        this.addRuleChainVisit(ASTAnnotationMethodDeclaration.class);
        this.addRuleChainVisit(ASTConstructorDeclaration.class);
    }

    private void reportUnnecessaryModifiers(Object data, Node node, Modifier unnecessaryModifier, String explanation) {
        this.reportUnnecessaryModifiers(data, node, EnumSet.of(unnecessaryModifier), explanation);
    }

    private void reportUnnecessaryModifiers(Object data, Node node, Set<Modifier> unnecessaryModifiers, String explanation) {
        if (unnecessaryModifiers.isEmpty()) {
            return;
        }
        super.addViolation(data, node, (Object[])new String[]{this.formatUnnecessaryModifiers(unnecessaryModifiers), this.getPrintableNodeKind(node), this.getNodeName(node), explanation.isEmpty() ? "" : ": " + explanation});
    }

    private String getNodeName(Node node) {
        if (node instanceof ASTMethodDeclaration) {
            return ((ASTMethodDeclaration)node).getMethodName();
        }
        if (node instanceof ASTMethodOrConstructorDeclaration) {
            return ((ASTConstructorDeclaration)node).getQualifiedName().getOperation();
        }
        if (node instanceof ASTFieldDeclaration) {
            return ((ASTFieldDeclaration)node).getVariableName();
        }
        if (node instanceof ASTResource) {
            return ((ASTResource)node).getVariableDeclaratorId().getImage();
        }
        return node.getImage();
    }

    private String getPrintableNodeKind(Node node) {
        if (node instanceof ASTAnyTypeDeclaration) {
            return ((ASTAnyTypeDeclaration)node).getTypeKind().getPrintableName();
        }
        if (node instanceof MethodLikeNode) {
            return ((MethodLikeNode)node).getKind().getPrintableName();
        }
        if (node instanceof ASTFieldDeclaration) {
            return "field";
        }
        if (node instanceof ASTResource) {
            return "resource specification";
        }
        throw new UnsupportedOperationException("Node " + node + " is unaccounted for");
    }

    private String formatUnnecessaryModifiers(Set<Modifier> set) {
        return (set.size() > 1 ? "s" : "") + " '" + StringUtils.join(set, (String)" ") + "'";
    }

    @Override
    public Object visit(ASTEnumDeclaration node, Object data) {
        if (node.isPublic()) {
            this.checkDeclarationInInterfaceType(data, node, EnumSet.of(Modifier.PUBLIC));
        }
        if (node.isStatic()) {
            this.reportUnnecessaryModifiers(data, (Node)node, Modifier.STATIC, "nested enums are implicitly static");
        }
        return data;
    }

    @Override
    public Object visit(ASTAnnotationTypeDeclaration node, Object data) {
        if (node.isAbstract()) {
            this.reportUnnecessaryModifiers(data, (Node)node, Modifier.ABSTRACT, "annotations types are implicitly abstract");
        }
        if (!node.isNested()) {
            return data;
        }
        if (node.isPublic() && node.enclosingTypeIsA(ASTAnyTypeDeclaration.TypeKind.INTERFACE, ASTAnyTypeDeclaration.TypeKind.ANNOTATION)) {
            this.reportUnnecessaryModifiers(data, (Node)node, Modifier.PUBLIC, "members of " + this.getPrintableNodeKind(node.getEnclosingTypeDeclaration()) + " types are implicitly public");
        }
        if (node.isStatic()) {
            this.reportUnnecessaryModifiers(data, (Node)node, Modifier.STATIC, "nested annotation types are implicitly static");
        }
        return data;
    }

    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (node.isInterface() && node.isAbstract()) {
            this.reportUnnecessaryModifiers(data, (Node)node, Modifier.ABSTRACT, "interface types are implicitly abstract");
        }
        if (!node.isNested()) {
            return data;
        }
        boolean isParentInterfaceOrAnnotation = node.enclosingTypeIsA(ASTAnyTypeDeclaration.TypeKind.INTERFACE, ASTAnyTypeDeclaration.TypeKind.ANNOTATION);
        if (node.isPublic() && isParentInterfaceOrAnnotation) {
            this.reportUnnecessaryModifiers(data, (Node)node, Modifier.PUBLIC, "members of " + this.getPrintableNodeKind(node.getEnclosingTypeDeclaration()) + " types are implicitly public");
        }
        if (node.isStatic()) {
            if (node.isInterface()) {
                this.reportUnnecessaryModifiers(data, (Node)node, Modifier.STATIC, "member interfaces are implicitly static");
            } else if (isParentInterfaceOrAnnotation) {
                this.reportUnnecessaryModifiers(data, (Node)node, Modifier.STATIC, "types nested within an interface type are implicitly static");
            }
        }
        return data;
    }

    @Override
    public Object visit(ASTMethodDeclaration node, Object data) {
        EnumSet<Modifier> unnecessary = EnumSet.noneOf(Modifier.class);
        if (node.isSyntacticallyPublic()) {
            unnecessary.add(Modifier.PUBLIC);
        }
        if (node.isSyntacticallyAbstract()) {
            unnecessary.add(Modifier.ABSTRACT);
        }
        this.checkDeclarationInInterfaceType(data, node, unnecessary);
        if (node.isFinal() && !this.isSafeVarargs(node)) {
            if (node.isPrivate()) {
                this.reportUnnecessaryModifiers(data, (Node)node, Modifier.FINAL, "private methods cannot be overridden");
            } else {
                Node n = node.getNthParent(3);
                if (n instanceof ASTAllocationExpression || n instanceof ASTEnumConstant) {
                    this.reportUnnecessaryModifiers(data, (Node)node, Modifier.FINAL, "an anonymous class cannot be extended");
                } else if (n instanceof ASTClassOrInterfaceDeclaration && ((AccessNode)n).isFinal()) {
                    this.reportUnnecessaryModifiers(data, (Node)node, Modifier.FINAL, "the method is already in a final class");
                }
            }
        }
        return data;
    }

    @Override
    public Object visit(ASTResource node, Object data) {
        if (node.isFinal()) {
            this.reportUnnecessaryModifiers(data, (Node)node, Modifier.FINAL, "resource specifications are implicitly final");
        }
        return data;
    }

    @Override
    public Object visit(ASTFieldDeclaration node, Object data) {
        EnumSet<Modifier> unnecessary = EnumSet.noneOf(Modifier.class);
        if (node.isSyntacticallyPublic()) {
            unnecessary.add(Modifier.PUBLIC);
        }
        if (node.isSyntacticallyStatic()) {
            unnecessary.add(Modifier.STATIC);
        }
        if (node.isSyntacticallyFinal()) {
            unnecessary.add(Modifier.FINAL);
        }
        this.checkDeclarationInInterfaceType(data, node, unnecessary);
        return data;
    }

    @Override
    public Object visit(ASTAnnotationMethodDeclaration node, Object data) {
        EnumSet<Modifier> unnecessary = EnumSet.noneOf(Modifier.class);
        if (node.isPublic()) {
            unnecessary.add(Modifier.PUBLIC);
        }
        if (node.isAbstract()) {
            unnecessary.add(Modifier.ABSTRACT);
        }
        this.checkDeclarationInInterfaceType(data, node, unnecessary);
        return data;
    }

    @Override
    public Object visit(ASTConstructorDeclaration node, Object data) {
        if (node.getNthParent(2) instanceof ASTEnumBody && node.isPrivate()) {
            this.reportUnnecessaryModifiers(data, (Node)node, Modifier.PRIVATE, "enum constructors are implicitly private");
        }
        return data;
    }

    private boolean isSafeVarargs(ASTMethodDeclaration node) {
        return node.isAnnotationPresent(SafeVarargs.class.getName());
    }

    private void checkDeclarationInInterfaceType(Object data, Node fieldOrMethod, Set<Modifier> unnecessary) {
        Node parent = fieldOrMethod.jjtGetParent().jjtGetParent().jjtGetParent();
        if (parent instanceof ASTAnnotationTypeDeclaration || parent instanceof ASTClassOrInterfaceDeclaration && ((ASTClassOrInterfaceDeclaration)parent).isInterface()) {
            this.reportUnnecessaryModifiers(data, fieldOrMethod, unnecessary, "the " + this.getPrintableNodeKind(fieldOrMethod) + " is declared in an " + this.getPrintableNodeKind(parent) + " type");
        }
    }

    private static enum Modifier {
        PUBLIC,
        PRIVATE,
        PROTECTED,
        STATIC,
        FINAL,
        ABSTRACT;


        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

